/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.cleanroommc.hackery.ReflectionHackery;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

class ObjectHolderRef {
    private Field field;
    private nf injectedObject;
    private boolean isValid;
    private ForgeRegistry<?> registry;

    ObjectHolderRef(Field field, nf injectedObject, boolean extractFromExistingValues) {
        this.registry = this.getRegistryForType(field);
        this.field = field;
        boolean bl2 = this.isValid = this.registry != null;
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (existing == null || existing == this.registry.getDefault()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isValid = false;
                    return;
                }
                this.injectedObject = ((IForgeRegistryEntry)existing).getRegistryName();
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that does not map to a registry. Ensure the registry was created during the RegistryEvent.NewRegistry event. (found : %s at %s.%s)", field.getType().getName(), field.getDeclaringClass().getName(), field.getName()));
        }
        try {
            field.setAccessible(true);
            ReflectionHackery.stripFieldOfFinalModifier(field);
        }
        catch (ReflectiveOperationException e3) {
            throw new RuntimeException(e3);
        }
    }

    @Nullable
    private ForgeRegistry<?> getRegistryForType(Field field) {
        LinkedList typesToExamine = new LinkedList();
        typesToExamine.add(field.getType());
        ForgeRegistry registry = null;
        while (!typesToExamine.isEmpty() && registry == null) {
            Class type = (Class)typesToExamine.remove();
            Collections.addAll(typesToExamine, type.getInterfaces());
            if (!IForgeRegistryEntry.class.isAssignableFrom(type)) continue;
            registry = (ForgeRegistry)GameRegistry.findRegistry(type);
            Class parentType = type.getSuperclass();
            if (parentType == null) continue;
            typesToExamine.add(parentType);
        }
        return registry;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void apply() {
        Object thing = this.isValid && this.registry.containsKey(this.injectedObject) && !this.registry.isDummied(this.injectedObject) ? this.registry.getValue(this.injectedObject) : null;
        if (thing == null) {
            FMLLog.log.debug("Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        try {
            ReflectionHackery.setField(this.field, null, thing);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e2) {
            FMLLog.log.warn("Unable to set {} with value {} ({})", (Object)this.field, thing, (Object)this.injectedObject, (Object)e2);
        }
    }
}

