/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LinkRepository;
import net.minecraftforge.fml.relauncher.libraries.MemoryModList;
import net.minecraftforge.fml.relauncher.libraries.ModList;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.fml.relauncher.libraries.SnapshotJson;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class LibraryManager {
    public static final boolean DISABLE_EXTERNAL_MANIFEST = Boolean.parseBoolean(System.getProperty("forge.disable_external_manifest", "false"));
    public static final boolean ENABLE_AUTO_MOD_MOVEMENT = Boolean.parseBoolean(System.getProperty("forge.enable_auto_mod_movement", "false"));
    private static final String LIBRARY_DIRECTORY_OVERRIDE = System.getProperty("forge.lib_folder", null);
    private static final List<String> skipContainedDeps = Arrays.asList(System.getProperty("fml.skipContainedDeps", "").split(","));
    private static final FilenameFilter MOD_FILENAME_FILTER = (dir, name) -> name.endsWith(".jar") || name.endsWith(".zip");
    private static final Comparator<File> FILE_NAME_SORTER_INSENSITVE = Comparator.comparing(o -> o.getName().toLowerCase(Locale.ENGLISH));
    public static final Attributes.Name MODSIDE = new Attributes.Name("ModSide");
    public static final Attributes.Name MODCONTAINSDEPS = new Attributes.Name("ContainedDeps");
    private static final Attributes.Name MAVEN_ARTIFACT = new Attributes.Name("Maven-Artifact");
    private static final Attributes.Name TIMESTAMP = new Attributes.Name("Timestamp");
    private static final Attributes.Name MD5 = new Attributes.Name("MD5");
    private static Repository libraries_dir = null;
    private static Set<File> processed = new HashSet<File>();
    private static File minecraftHome;
    private static List<File> candidates;

    public static void setup(File minecraftHome) {
        LibraryManager.minecraftHome = minecraftHome;
        File libDir = LibraryManager.findLibraryFolder(minecraftHome);
        FMLLog.log.debug("Determined Minecraft Libraries Root: {}", (Object)libDir);
        Repository old = Repository.replace(libDir, "libraries");
        if (old != null) {
            FMLLog.log.debug("  Overwriting Previous: {}", (Object)old);
        }
        libraries_dir = Repository.get("libraries");
        File mods = new File(minecraftHome, "mods");
        File mods_ver = new File(mods, "1.12.2");
        MemoryModList memory = null;
        if (!ENABLE_AUTO_MOD_MOVEMENT) {
            LinkRepository repo = new LinkRepository(new File(mods, "memory_repo"));
            memory = new MemoryModList(repo);
            ModList.cache.put("MEMORY", memory);
            Repository.cache.put("MEMORY", repo);
        }
        for (File dir : new File[]{mods, mods_ver}) {
            LibraryManager.cleanDirectory(dir, ENABLE_AUTO_MOD_MOVEMENT ? ModList.create(new File(dir, "mod_list.json"), minecraftHome) : memory, mods_ver, mods);
        }
        for (ModList list : ModList.getKnownLists(minecraftHome)) {
            Repository repo = list.getRepository() == null ? libraries_dir : list.getRepository();
            List<Artifact> artifacts = list.getArtifacts();
            for (int i2 = 0; i2 < artifacts.size(); ++i2) {
                File target;
                Artifact artifact = artifacts.get(i2);
                Artifact resolved = repo.resolve(artifact);
                if (resolved == null || !(target = repo.getFile(resolved.getPath())).exists()) continue;
                LibraryManager.extractPacked(target, list, mods_ver, mods);
            }
        }
    }

    private static File findLibraryFolder(File minecraftHome) {
        if (LIBRARY_DIRECTORY_OVERRIDE != null) {
            FMLLog.log.error("System variable set to override Library Directory: {}", (Object)LIBRARY_DIRECTORY_OVERRIDE);
            return new File(LIBRARY_DIRECTORY_OVERRIDE);
        }
        CodeSource source = ArtifactVersion.class.getProtectionDomain().getCodeSource();
        if (source == null) {
            FMLLog.log.error("Unable to determine codesource for {}. Using default libraries directory.", (Object)ArtifactVersion.class.getName());
            return new File(minecraftHome, "libraries");
        }
        try {
            Object comp;
            File apache = new File(source.getLocation().toURI());
            if (apache.isFile()) {
                apache = apache.getParentFile();
            }
            if (!((String)(comp = (apache = apache.getParentFile()).getAbsolutePath().toLowerCase(Locale.ENGLISH).replace('\\', '/'))).endsWith("/")) {
                comp = (String)comp + "/";
            }
            if (!((String)comp).endsWith("/org/apache/maven/maven-artifact/")) {
                FMLLog.log.error("Apache Maven library folder was not in the format expected. Using default libraries directory.");
                FMLLog.log.error("Full: {}", (Object)new File(source.getLocation().toURI()));
                FMLLog.log.error("Trimmed: {}", comp);
                return new File(minecraftHome, "libraries");
            }
            return apache.getParentFile().getParentFile().getParentFile().getParentFile();
        }
        catch (URISyntaxException e2) {
            FMLLog.log.error(FMLLog.log.getMessageFactory().newMessage("Unable to determine file for {}. Using default libraries directory.", new Object[]{ArtifactVersion.class.getName()}), (Throwable)e2);
            return new File(minecraftHome, "libraries");
        }
    }

    private static void cleanDirectory(File dir, ModList modlist, File ... modDirs) {
        if (!dir.exists()) {
            return;
        }
        FMLLog.log.debug("Cleaning up mods folder: {}", (Object)dir);
        for (File file : dir.listFiles(f2 -> f2.isFile() && f2.getName().endsWith(".jar"))) {
            Pair<Artifact, byte[]> ret = LibraryManager.extractPacked(file, modlist, modDirs);
            if (ret == null) continue;
            Artifact artifact = (Artifact)ret.getLeft();
            Repository repo = modlist.getRepository() == null ? libraries_dir : modlist.getRepository();
            File moved = repo.archive(artifact, file, (byte[])ret.getRight());
            processed.add(moved);
        }
        try {
            if (modlist.changed()) {
                modlist.save();
            }
        }
        catch (IOException e2) {
            FMLLog.log.error(FMLLog.log.getMessageFactory().newMessage("Error updating modlist file {}", new Object[]{modlist.getName()}), (Throwable)e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Artifact, byte[]> extractPacked(File file, ModList modlist, File ... modDirs) {
        if (processed.contains(file)) {
            FMLLog.log.debug("File already proccessed {}, Skipping", (Object)file.getAbsolutePath());
            return null;
        }
        try (JarFile jar = new JarFile(file);){
            FMLLog.log.debug("Examining file: {}", (Object)file.getName());
            processed.add(file);
            Pair<Artifact, byte[]> pair = LibraryManager.extractPacked(jar, modlist, modDirs);
            return pair;
        }
        catch (IOException e2) {
            FMLLog.log.error("Unable to read the file {} as jar file - ignoring", (Object)file.getName(), (Object)e2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Artifact, byte[]> extractPacked(JarFile jar, ModList modlist, File ... modDirs) throws IOException {
        Attributes attrs;
        String modSide;
        if (jar.getManifest() == null) {
            return null;
        }
        JarEntry manifest_entry = jar.getJarEntry("META-INF/MANIFEST.MF");
        if (manifest_entry == null) {
            manifest_entry = jar.stream().filter(e2 -> "META-INF/MANIFEST.MF".equals(e2.getName().toUpperCase(Locale.ENGLISH))).findFirst().get();
        }
        if ((modSide = (attrs = jar.getManifest().getMainAttributes()).getValue(MODSIDE)) != null && !"BOTH".equals(modSide) && !FMLLaunchHandler.side().name().equals(modSide)) {
            return null;
        }
        if (attrs.containsKey(MODCONTAINSDEPS)) {
            for (String string : attrs.getValue(MODCONTAINSDEPS).split(" ")) {
                File target;
                void var9_9;
                JarEntry depEntry;
                if (!string.endsWith(".jar")) {
                    FMLLog.log.error("Contained Dep is not a jar file: {}", (Object)string);
                    throw new IllegalStateException("Invalid contained dep, Must be jar: " + string);
                }
                if (jar.getJarEntry(string) == null && jar.getJarEntry("META-INF/libraries/" + string) != null) {
                    String string2 = "META-INF/libraries/" + string;
                }
                if ((depEntry = jar.getJarEntry((String)var9_9)) == null) {
                    FMLLog.log.error("Contained Dep is not in the jar: {}", (Object)var9_9);
                    throw new IllegalStateException("Invalid contained dep, Missing from jar: " + (String)var9_9);
                }
                String depEndName = new File((String)var9_9).getName();
                if (skipContainedDeps.contains(var9_9) || skipContainedDeps.contains(depEndName)) {
                    FMLLog.log.error("Skipping dep at request: {}", (Object)var9_9);
                    continue;
                }
                Attributes meta = null;
                byte[] data = null;
                byte[] manifest_data = null;
                JarEntry metaEntry = jar.getJarEntry((String)var9_9 + ".meta");
                if (metaEntry != null) {
                    manifest_data = LibraryManager.readAll(jar.getInputStream(metaEntry));
                    meta = new Manifest(new ByteArrayInputStream(manifest_data)).getMainAttributes();
                } else {
                    data = LibraryManager.readAll(jar.getInputStream(depEntry));
                    try (ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(data));){
                        File[] ze = null;
                        while ((ze = zi.getNextEntry()) != null) {
                            if (!ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                            manifest_data = LibraryManager.readAll(zi);
                            meta = new Manifest(new ByteArrayInputStream(manifest_data)).getMainAttributes();
                            break;
                        }
                    }
                }
                if (meta == null || !meta.containsKey(MAVEN_ARTIFACT)) {
                    boolean found = false;
                    for (File dir : modDirs) {
                        File target2 = new File(dir, depEndName);
                        if (!target2.exists()) continue;
                        FMLLog.log.debug("Found existing ContainDep extracted to {}, skipping extraction", (Object)target2.getCanonicalPath());
                        found = true;
                    }
                    if (found) continue;
                    target = new File(modDirs[0], depEndName);
                    FMLLog.log.debug("Extracting ContainedDep {} from {} to {}", (Object)var9_9, (Object)jar.getName(), (Object)target.getCanonicalPath());
                    try {
                        Files.createParentDirs((File)target);
                        try (FileOutputStream out = new FileOutputStream(target);
                             InputStream in = data == null ? jar.getInputStream(depEntry) : new ByteArrayInputStream(data);){
                            ByteStreams.copy((InputStream)in, (OutputStream)out);
                        }
                        FMLLog.log.debug("Extracted ContainedDep {} from {} to {}", (Object)var9_9, (Object)jar.getName(), (Object)target.getCanonicalPath());
                        LibraryManager.extractPacked(target, modlist, modDirs);
                    }
                    catch (IOException e3) {
                        FMLLog.log.error("An error occurred extracting dependency", (Throwable)e3);
                    }
                    continue;
                }
                try {
                    Pair<Artifact, byte[]> child;
                    Artifact artifact = LibraryManager.readArtifact(modlist.getRepository(), meta);
                    target = artifact.getFile();
                    if (target.exists()) {
                        Pair<Artifact, byte[]> child2;
                        FMLLog.log.debug("Found existing ContainedDep {}({}) from {} extracted to {}, skipping extraction", (Object)var9_9, (Object)artifact.toString(), (Object)target.getCanonicalPath(), (Object)jar.getName());
                        if (ENABLE_AUTO_MOD_MOVEMENT || (child2 = LibraryManager.extractPacked(target, modlist, modDirs)) != null || metaEntry == null) continue;
                        modlist.add(artifact);
                        continue;
                    }
                    FMLLog.log.debug("Extracting ContainedDep {}({}) from {} to {}", (Object)var9_9, (Object)artifact.toString(), (Object)jar.getName(), (Object)target.getCanonicalPath());
                    Files.createParentDirs((File)target);
                    try (FileOutputStream out = new FileOutputStream(target);
                         InputStream in = data == null ? jar.getInputStream(depEntry) : new ByteArrayInputStream(data);){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    FMLLog.log.debug("Extracted ContainedDep {}({}) from {} to {}", (Object)var9_9, (Object)artifact.toString(), (Object)jar.getName(), (Object)target.getCanonicalPath());
                    if (artifact.isSnapshot()) {
                        SnapshotJson json = SnapshotJson.create(artifact.getSnapshotMeta());
                        json.add(new SnapshotJson.Entry(artifact.getTimestamp(), meta.getValue(MD5)));
                        json.write(artifact.getSnapshotMeta());
                    }
                    if (!DISABLE_EXTERNAL_MANIFEST) {
                        File meta_target = new File(target.getAbsolutePath() + ".meta");
                        Files.write((byte[])manifest_data, (File)meta_target);
                    }
                    if ((child = LibraryManager.extractPacked(target, modlist, modDirs)) != null || metaEntry == null) continue;
                    modlist.add(artifact);
                }
                catch (NumberFormatException nfe) {
                    FMLLog.log.error(FMLLog.log.getMessageFactory().newMessage("An error occurred extracting dependency. Invalid Timestamp: {}", new Object[]{meta.getValue(TIMESTAMP)}), (Throwable)nfe);
                }
                catch (IOException e4) {
                    FMLLog.log.error("An error occurred extracting dependency", (Throwable)e4);
                }
            }
        }
        if (attrs.containsKey(MAVEN_ARTIFACT)) {
            Artifact artifact = LibraryManager.readArtifact(modlist.getRepository(), attrs);
            modlist.add(artifact);
            return Pair.of((Object)artifact, (Object)LibraryManager.readAll(jar.getInputStream(manifest_entry)));
        }
        return null;
    }

    private static Artifact readArtifact(Repository repo, Attributes meta) {
        String timestamp = meta.getValue(TIMESTAMP);
        if (timestamp != null) {
            timestamp = SnapshotJson.TIMESTAMP.format(new Date(Long.parseLong(timestamp)));
        }
        return new Artifact(repo, meta.getValue(MAVEN_ARTIFACT), timestamp);
    }

    private static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = -1;
        byte[] data = new byte[16384];
        while ((read = in.read(data, 0, data.length)) != -1) {
            out.write(data, 0, read);
        }
        out.flush();
        return out.toByteArray();
    }

    public static List<Artifact> flattenLists(File mcDir) {
        ArrayList<Artifact> merged = new ArrayList<Artifact>();
        for (ModList list : ModList.getBasicLists(mcDir)) {
            for (Artifact art : list.flatten()) {
                Optional<Artifact> old = merged.stream().filter(art::matchesID).findFirst();
                if (!old.isPresent()) {
                    merged.add(art);
                    continue;
                }
                if (old.get().getVersion().compareTo(art.getVersion()) >= 0) continue;
                merged.add(merged.indexOf(old.get()), art);
                merged.remove(old.get());
            }
        }
        return merged;
    }

    public static List<File> gatherLegacyCanidates(File mcDir) {
        Map args;
        String extraMods;
        ArrayList<File> list = new ArrayList<File>();
        String extrapath = System.getProperty("crl.dev.extrapath");
        if (extrapath != null) {
            for (String mod : extrapath.split(File.pathSeparator)) {
                File file = new File(mod);
                if (file.exists()) {
                    list.add(file);
                    FMLLog.log.info("Adding extra mod file {}", (Object)file);
                    continue;
                }
                FMLLog.log.debug("Mod file {} does not exist", (Object)file);
            }
        }
        if ((extraMods = (String)(args = (Map)Launch.blackboard.get("forgeLaunchArgs")).get("--mods")) != null) {
            FMLLog.log.info("Found mods from the command line:");
            for (String mod : extraMods.split(",")) {
                File file = new File(mcDir, mod);
                if (!file.exists()) {
                    FMLLog.log.info("  Failed to find mod file {} ({})", (Object)mod, (Object)file.getAbsolutePath());
                    continue;
                }
                if (!list.contains(file)) {
                    FMLLog.log.debug("  Adding {} ({}) to the mod list", (Object)mod, (Object)file.getAbsolutePath());
                    list.add(file);
                    continue;
                }
                if (list.contains(file)) continue;
                FMLLog.log.debug("  Duplicte command line mod detected {} ({})", (Object)mod, (Object)file.getAbsolutePath());
            }
        }
        for (String dir : new String[]{"mods", "mods" + File.separatorChar + "1.12.2"}) {
            File base = new File(mcDir, dir);
            if (!base.isDirectory() || !base.exists()) continue;
            FMLLog.log.info("Searching {} for mods", (Object)base.getAbsolutePath());
            for (File f2 : base.listFiles(MOD_FILENAME_FILTER)) {
                if (list.contains(f2)) continue;
                FMLLog.log.debug("  Adding {} to the mod list", (Object)f2.getName());
                list.add(f2);
            }
        }
        ModList memory = ModList.cache.get("MEMORY");
        if (!ENABLE_AUTO_MOD_MOVEMENT && memory != null && memory.getRepository() != null) {
            memory.getRepository().filterLegacy(list);
        }
        list.sort(FILE_NAME_SORTER_INSENSITVE);
        return list;
    }

    public static List<File> getCandidates() {
        if (candidates != null) {
            return candidates;
        }
        candidates = LibraryManager.gatherLegacyCanidates(minecraftHome);
        Method bansoukouMethod = null;
        for (File candidate : candidates) {
            if (candidate.isDirectory()) continue;
            try (JarFile jar2 = new JarFile(candidate);){
                String bansoukou;
                Attributes attributes = jar2.getManifest() == null ? null : jar2.getManifest().getMainAttributes();
                if (attributes == null || (bansoukou = attributes.getValue("Bansoukou")) == null) continue;
                Launch.classLoader.addURL(candidate.toURI().toURL());
                Launch.classLoader.addTransformerExclusion(bansoukou);
                Class<?> cleanBansoukou = Class.forName(bansoukou, true, (ClassLoader)Launch.classLoader);
                bansoukouMethod = cleanBansoukou.getMethod("bansoukou", List.class);
                break;
            }
            catch (IOException jar2) {
            }
            catch (ClassNotFoundException | NoSuchMethodException e2) {
                throw new RuntimeException("Unable to instantiate linkage with Bansoukou", e2);
            }
        }
        for (Artifact artifact : LibraryManager.flattenLists(minecraftHome)) {
            File target;
            if ((artifact = Repository.resolveAll(artifact)) == null || candidates.contains(target = artifact.getFile())) continue;
            candidates.add(target);
        }
        if (bansoukouMethod != null) {
            try {
                bansoukouMethod.invoke(null, candidates);
            }
            catch (Exception e3) {
                throw new RuntimeException("Unable to invoke linkage with Bansoukou", e3);
            }
        }
        return candidates;
    }

    public static Repository getDefaultRepo() {
        return libraries_dir;
    }
}

