/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.ForgeEarlyConfig;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer;
import net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.MixinBooterPlugin;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class CoreModManager {
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");
    private static final Attributes.Name FORCELOADASMOD = new Attributes.Name("ForceLoadAsMod");
    private static final Attributes.Name MODTYPE = new Attributes.Name("ModType");
    private static final Set<String> loadedPlugins = new HashSet<String>();
    private static String[] rootPlugins = new String[]{"net.minecraftforge.fml.relauncher.FMLCorePlugin", "net.minecraftforge.classloading.FMLForgePlugin", "net.minecraftforge.fml.relauncher.MixinBooterPlugin"};
    private static List<String> ignoredModFiles = Lists.newArrayList();
    private static Map<String, List<String>> transformers = Maps.newHashMap();
    private static List<FMLPluginWrapper> loadPlugins;
    private static FMLTweaker tweaker;
    private static File mcDir;
    private static List<String> candidateModFiles;
    private static List<String> accessTransformers;
    private static Set<String> rootNames;
    static boolean deobfuscatedEnvironment;
    private static final Map<String, Integer> tweakSorting;

    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader, FMLTweaker tweaker) {
        CoreModManager.mcDir = mcDir;
        CoreModManager.tweaker = tweaker;
        try {
            byte[] bs = classLoader.getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLLog.log.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation");
                deobfuscatedEnvironment = true;
            }
        }
        catch (IOException bs) {
            // empty catch block
        }
        if (!deobfuscatedEnvironment) {
            FMLLog.log.debug("Enabling runtime deobfuscation");
        } else if (System.getProperty("log4j.configurationFile") == null) {
            FMLLog.log.info("Detected deobfuscated environment, loading log configs for colored console logs.");
            System.setProperty("log4j.configurationFile", "log4j2_server.xml");
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
        tweaker.injectCascadingTweak("net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker");
        tweaker.injectCascadingTweak("org.spongepowered.asm.launch.MixinTweaker");
        try {
            classLoader.registerTransformer("net.minecraftforge.fml.common.asm.transformers.PatchingTransformer");
        }
        catch (Exception e2) {
            throw new RuntimeException("The patch transformer failed to load! This is critical, loading cannot continue!", e2);
        }
        loadPlugins = new ArrayList<FMLPluginWrapper>();
        for (String rootPluginName : rootPlugins) {
            CoreModManager.loadCoreMod(classLoader, rootPluginName, new File(FMLTweaker.getJarLocation()));
        }
        if (loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occurred - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLLog.log.debug("All fundamental core mods are successfully located");
        if (System.getProperty("crl.dev.extrapath") != null) {
            for (String path : System.getProperty("crl.dev.extrapath").split(File.pathSeparator)) {
                try {
                    Launch.classLoader.addURL(new File(path).getAbsoluteFile().toURI().toURL());
                    FMLLog.log.debug("Adding extra path {} to class path", (Object)path);
                }
                catch (MalformedURLException e3) {
                    FMLLog.log.error("Failed to add path {} to class path, this souldn't happen!", (Object)path, (Object)e3);
                }
            }
        }
        String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
        for (String coreModClassName : commandLineCoremods.split(",")) {
            if (coreModClassName.isEmpty()) continue;
            FMLLog.log.info("Found a command line coremod : {}", (Object)coreModClassName);
            CoreModManager.loadCoreMod(classLoader, coreModClassName, null);
        }
        CoreModManager.discoverCoreMods(mcDir, classLoader);
    }

    private static void findDerpMods(LaunchClassLoader classLoader, File modDir, File modDirVer) {
        FileFilter derpdirfilter;
        File[] derpdirlist;
        File[] derplist = CoreModManager.listFiles(path -> path.getName().endsWith(".jar.zip"), modDir, modDirVer);
        if (derplist != null && derplist.length > 0) {
            FMLLog.log.fatal("FML has detected several badly downloaded jar files,  which have been named as zip files. You probably need to download them again, or they may not work properly");
            for (File f2 : derplist) {
                FMLLog.log.fatal("Problem file : {}", (Object)f2.getName());
            }
        }
        if ((derpdirlist = CoreModManager.listFiles(derpdirfilter = pathname -> pathname.isDirectory() && new File(pathname, "META-INF").isDirectory(), modDir, modDirVer)) != null && derpdirlist.length > 0) {
            FMLLog.log.fatal("There appear to be jars extracted into the mods directory. This is VERY BAD and will almost NEVER WORK WELL");
            FMLLog.log.fatal("You should place original jars only in the mods directory. NEVER extract them to the mods directory.");
            FMLLog.log.fatal("The directories below appear to be extracted jar files. Fix this before you continue.");
            for (File f3 : derpdirlist) {
                FMLLog.log.fatal("Directory {} contains {}", (Object)f3.getName(), Arrays.asList(new File(f3, "META-INF").list()));
            }
            RuntimeException re = new RuntimeException("Extracted mod jars found, loading will NOT continue");
            try {
                Class crashreportclass = classLoader.loadClass("b");
                Object crashreport = crashreportclass.getMethod("a", Throwable.class, String.class).invoke(null, re, "FML has discovered extracted jar files in the mods directory.\nThis breaks mod loading functionality completely.\nRemove the directories and replace with the jar files originally provided.");
                File crashreportfile = new File(new File(modDir.getParentFile(), "crash-reports"), String.format("fml-crash-%1$tY-%1$tm-%1$td_%1$tH.%1$tM.%1$tS.txt", Calendar.getInstance()));
                crashreportclass.getMethod("a", File.class).invoke(crashreport, crashreportfile);
                FMLLog.log.fatal("#@!@# FML has crashed the game deliberately. Crash report saved to: #@!@# {}", (Object)crashreportfile.getAbsolutePath());
            }
            catch (Exception e2) {
                FMLLog.log.fatal("#@!@# FML has crashed while generating a crash report, please report this. #@!@#", (Throwable)e2);
            }
            throw re;
        }
    }

    private static File[] listFiles(FileFilter filter, File ... dirs) {
        Object[] ret = null;
        for (File dir : dirs) {
            if (!dir.isDirectory() || !dir.exists()) continue;
            ret = ret == null ? dir.listFiles(filter) : (File[])ObjectArrays.concat((Object[])ret, (Object[])dir.listFiles(filter), File.class);
        }
        return ret == null ? new File[]{} : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader) {
        File modsDir = CoreModManager.setupCoreModDir(mcDir);
        File modsDirVer = new File(modsDir, FMLInjectionData.mccversion);
        CoreModManager.findDerpMods(classLoader, modsDir, modsDirVer);
        FMLLog.log.debug("Discovering coremods");
        List<File> candidates = LibraryManager.getCandidates();
        HashSet<String> mixin_configs = new HashSet<String>();
        File mods_ver = new File(new File(Launch.minecraftHome, "mods"), "1.12.2");
        Iterator<File> iterator = candidates.iterator();
        while (true) {
            String fmlCorePlugin;
            File coreMod;
            block40: {
                boolean containNonMods;
                String configs;
                Attributes mfAttributes;
                JarFile jar;
                if (iterator.hasNext()) {
                    ImmutableList modTypes;
                    coreMod = iterator.next();
                    if (coreMod.isDirectory()) {
                        FMLLog.log.debug("Ignoring folder {} in coremod searching", (Object)coreMod);
                        continue;
                    }
                    FMLLog.log.debug("Examining for coremod candidacy {}", (Object)coreMod.getName());
                    jar = null;
                    boolean ignoreMods = false;
                    File manifest = new File(coreMod.getAbsolutePath() + ".meta");
                    if (LibraryManager.DISABLE_EXTERNAL_MANIFEST || !manifest.exists()) {
                        jar = new JarFile(coreMod);
                        mfAttributes = jar.getManifest() == null ? null : jar.getManifest().getMainAttributes();
                    } else {
                        FileInputStream fis = new FileInputStream(manifest);
                        mfAttributes = new Manifest(fis).getMainAttributes();
                        fis.close();
                    }
                    if (mfAttributes == null) {
                        CoreModManager.closeQuietly(jar);
                        continue;
                    }
                    String modSide = mfAttributes.getValue(LibraryManager.MODSIDE);
                    if (modSide != null && !"BOTH".equals(modSide) && !FMLLaunchHandler.side().name().equals(modSide)) {
                        FMLLog.log.debug("Mod {} has ModSide meta-inf value {}, and we're {} It will be ignored", (Object)coreMod.getName(), (Object)modSide, (Object)FMLLaunchHandler.side.name());
                        ignoredModFiles.add(coreMod.getName());
                        CoreModManager.closeQuietly(jar);
                        continue;
                    }
                    String ats = mfAttributes.getValue(ModAccessTransformer.FMLAT);
                    if (ats != null && !ats.isEmpty()) {
                        if (jar == null) {
                            jar = new JarFile(coreMod);
                        }
                        ModAccessTransformer.addJar(jar, ats);
                    }
                    configs = mfAttributes.getValue("MixinConfigs");
                    String cascadedTweaker = mfAttributes.getValue("TweakClass");
                    containNonMods = Boolean.parseBoolean(mfAttributes.getValue("NonModDeps"));
                    if (cascadedTweaker != null) {
                        if (containNonMods) {
                            for (String file : mfAttributes.getValue(LibraryManager.MODCONTAINSDEPS).split(" ")) {
                                classLoader.addURL(new File(mods_ver, file).getAbsoluteFile().toURI().toURL());
                            }
                        }
                        FMLLog.log.info("Loading tweaker {} from {}", (Object)cascadedTweaker, (Object)coreMod.getName());
                        Integer sortOrder = Ints.tryParse((String)Strings.nullToEmpty((String)mfAttributes.getValue("TweakOrder")));
                        sortOrder = sortOrder == null ? Integer.valueOf(0) : sortOrder;
                        CoreModManager.handleCascadingTweak(coreMod, jar, cascadedTweaker, classLoader, sortOrder);
                        if (!Strings.isNullOrEmpty((String)configs)) {
                            for (String singleMixinConfig : configs.split(",")) {
                                mixin_configs.add(singleMixinConfig.trim());
                            }
                        }
                        ignoredModFiles.add(coreMod.getName());
                        if (!"org.spongepowered.asm.launch.MixinTweaker".equals(cascadedTweaker)) {
                            CoreModManager.closeQuietly(jar);
                            continue;
                        }
                    }
                    Object object = modTypes = mfAttributes.containsKey(MODTYPE) ? Arrays.asList(mfAttributes.getValue(MODTYPE).split(",")) : ImmutableList.of((Object)"FML");
                    if (!modTypes.contains("FML") && !modTypes.contains("CRL")) {
                        FMLLog.log.debug("Adding {} to the list of things to skip. It is not an FML mod, it has types {}", (Object)coreMod.getName(), (Object)modTypes);
                        ignoredModFiles.add(coreMod.getName());
                        CoreModManager.closeQuietly(jar);
                        continue;
                    }
                    fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
                    for (String plugin : ForgeEarlyConfig.LOADING_PLUGIN_BLACKLIST) {
                        if (!plugin.equals(fmlCorePlugin)) continue;
                        ignoreMods = true;
                        break;
                    }
                    if (ignoreMods) {
                        ignoredModFiles.add(coreMod.getName());
                        FMLLog.log.warn("The mod with loading plugin {} is in blacklist and won't be loaded. Check forge_early.cfg for more info.", (Object)fmlCorePlugin);
                        CoreModManager.closeQuietly(jar);
                        continue;
                    }
                    if (fmlCorePlugin == null) {
                        FMLLog.log.debug("Not found coremod data in {}", (Object)coreMod.getName());
                        if ("org.spongepowered.asm.launch.MixinTweaker".equals(cascadedTweaker) && (mfAttributes.containsKey(COREMODCONTAINSFMLMOD) || mfAttributes.containsKey(FORCELOADASMOD))) {
                            FMLLog.log.info("Found FMLCorePluginContainsFMLMod marker in mixin container {}.", (Object)coreMod.getName());
                            candidateModFiles.add(coreMod.getName());
                            ignoredModFiles.remove(coreMod.getName());
                        }
                        CoreModManager.closeQuietly(jar);
                        continue;
                    }
                    CoreModManager.closeQuietly(jar);
                } else {
                    String devConfigs = System.getProperty("crl.dev.mixin");
                    if (!Strings.isNullOrEmpty((String)devConfigs)) {
                        for (String singleMixinConfig : devConfigs.split(",")) {
                            mixin_configs.add(singleMixinConfig.trim());
                        }
                    }
                    Launch.blackboard.put("MixinConfigs", mixin_configs);
                    return;
                }
                try {
                    if (containNonMods) {
                        for (String file : mfAttributes.getValue(LibraryManager.MODCONTAINSDEPS).split(" ")) {
                            classLoader.addURL(new File(mods_ver, file).getAbsoluteFile().toURI().toURL());
                        }
                    }
                    classLoader.addURL(coreMod.toURI().toURL());
                    if (!Strings.isNullOrEmpty((String)configs)) {
                        mixin_configs.addAll(List.of(configs.split(",")));
                    }
                    if (!mfAttributes.containsKey(COREMODCONTAINSFMLMOD) && !mfAttributes.containsKey(FORCELOADASMOD)) {
                        FMLLog.log.trace("Adding {} to the list of known coremods, it will not be examined again", (Object)coreMod.getName());
                        ignoredModFiles.add(coreMod.getName());
                        break block40;
                    } else {
                        FMLLog.log.info("Found FMLCorePluginContainsFMLMod marker in {}.", (Object)coreMod.getName());
                        candidateModFiles.add(coreMod.getName());
                        ignoredModFiles.remove(coreMod.getName());
                    }
                    break block40;
                }
                catch (MalformedURLException e2) {
                    FMLLog.log.error("Unable to convert file into a URL. weird", (Throwable)e2);
                    continue;
                }
                catch (IOException ioe) {
                    FMLLog.log.error("Unable to read the jar file {} - ignoring", (Object)coreMod.getName(), (Object)ioe);
                    continue;
                }
                finally {
                    CoreModManager.closeQuietly(jar);
                    continue;
                }
            }
            CoreModManager.loadCoreMod(classLoader, fmlCorePlugin, coreMod);
        }
    }

    private static void handleCascadingTweak(File coreMod, JarFile jar, String cascadedTweaker, LaunchClassLoader classLoader, Integer sortingOrder) throws MalformedURLException {
        try {
            classLoader.addURL(coreMod.toURI().toURL());
            tweaker.injectCascadingTweak(cascadedTweaker);
            tweakSorting.put(cascadedTweaker, sortingOrder);
        }
        catch (Exception e2) {
            FMLLog.log.info("There was a problem trying to load the mod dir tweaker {}", (Object)coreMod.getAbsolutePath(), (Object)e2);
        }
    }

    private static File setupCoreModDir(File mcDir) {
        File coreModDir = new File(mcDir, "mods");
        try {
            coreModDir = coreModDir.getCanonicalFile();
        }
        catch (IOException e2) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), e2);
        }
        if (!coreModDir.exists()) {
            coreModDir.mkdir();
        } else if (coreModDir.exists() && !coreModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return coreModDir;
    }

    public static List<String> getIgnoredMods() {
        return ignoredModFiles;
    }

    public static Map<String, List<String>> getTransformers() {
        return transformers;
    }

    public static List<String> getReparseableCoremods() {
        return candidateModFiles;
    }

    private static FMLPluginWrapper loadCoreMod(LaunchClassLoader classLoader, String coreModClass, File location) {
        if (loadedPlugins.contains(coreModClass)) {
            return null;
        }
        String coreModName = coreModClass.substring(coreModClass.lastIndexOf(46) + 1);
        try {
            IFMLLoadingPlugin.SortingIndex index;
            FMLLog.log.debug("Instantiating coremod class {}", (Object)coreModName);
            classLoader.addTransformerExclusion(coreModClass);
            Class<?> coreModClazz = Class.forName(coreModClass, true, (ClassLoader)classLoader);
            IFMLLoadingPlugin.Name coreModNameAnn = coreModClazz.getAnnotation(IFMLLoadingPlugin.Name.class);
            if (coreModNameAnn != null && !Strings.isNullOrEmpty((String)coreModNameAnn.value())) {
                coreModName = coreModNameAnn.value();
                FMLLog.log.trace("coremod named {} is loading", (Object)coreModName);
            }
            IFMLLoadingPlugin.MCVersion requiredMCVersion = coreModClazz.getAnnotation(IFMLLoadingPlugin.MCVersion.class);
            if (!Arrays.asList(rootPlugins).contains(coreModClass) && (requiredMCVersion == null || Strings.isNullOrEmpty((String)requiredMCVersion.value()))) {
                FMLLog.log.debug("The coremod {} does not have a MCVersion annotation, it may cause issues with this version of Minecraft", (Object)coreModClass);
            } else {
                if (requiredMCVersion != null && !FMLInjectionData.mccversion.equals(requiredMCVersion.value())) {
                    FMLLog.log.error("The coremod {} is requesting minecraft version {} and minecraft is {}. It will be ignored.", (Object)coreModClass, (Object)requiredMCVersion.value(), (Object)FMLInjectionData.mccversion);
                    return null;
                }
                if (requiredMCVersion != null) {
                    FMLLog.log.debug("The coremod {} requested minecraft version {} and minecraft is {}. It will be loaded.", (Object)coreModClass, (Object)requiredMCVersion.value(), (Object)FMLInjectionData.mccversion);
                }
            }
            IFMLLoadingPlugin.TransformerExclusions trExclusions = coreModClazz.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class);
            if (trExclusions != null) {
                for (String st : trExclusions.value()) {
                    classLoader.addTransformerExclusion(st);
                }
            }
            IFMLLoadingPlugin.DependsOn deplist = coreModClazz.getAnnotation(IFMLLoadingPlugin.DependsOn.class);
            String[] dependencies = new String[]{};
            if (deplist != null) {
                dependencies = deplist.value();
            }
            int sortIndex = (index = coreModClazz.getAnnotation(IFMLLoadingPlugin.SortingIndex.class)) != null ? index.value() : 0;
            Certificate[] certificates = coreModClazz.getProtectionDomain().getCodeSource().getCertificates();
            ImmutableList<String> certList = CertificateHelper.getFingerprints(certificates);
            if (certList.isEmpty()) {
                if (deobfuscatedEnvironment && Arrays.asList(rootPlugins).contains(coreModClass)) {
                    FMLLog.log.info("Ignoring missing certificate for coremod {} ({}), we are in deobf and it's a forge core plugin", (Object)coreModName, (Object)coreModClass);
                } else if (deobfuscatedEnvironment && location == null) {
                    FMLLog.log.info("Ignoring missing certificate for coremod {} ({}), as this is probably a dev workspace", (Object)coreModName, (Object)coreModClass);
                } else {
                    FMLLog.log.debug("The coremod {} ({}) is not signed!", (Object)coreModName, (Object)coreModClass);
                }
            } else {
                FMLLog.log.debug("Found signing certificates for coremod {} ({})", (Object)coreModName, (Object)coreModClass);
                for (String cert : certList) {
                    FMLLog.log.debug("Found certificate {}", (Object)cert);
                }
            }
            IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            String accessTransformerClass = plugin.getAccessTransformerClass();
            if (accessTransformerClass != null) {
                FMLLog.log.debug("Added access transformer class {} to enqueued access transformers", (Object)accessTransformerClass);
                accessTransformers.add(accessTransformerClass);
            }
            FMLPluginWrapper wrap = new FMLPluginWrapper(coreModName, plugin, location, sortIndex, dependencies);
            loadPlugins.add(wrap);
            loadedPlugins.add(coreModClass);
            FMLLog.log.debug("Enqueued coremod {}", (Object)coreModName);
            MixinBooterPlugin.queneEarlyMixinLoader(plugin);
            return wrap;
        }
        catch (ClassNotFoundException cnfe) {
            if (!Lists.newArrayList((Object[])rootPlugins).contains(coreModClass)) {
                FMLLog.log.error("Coremod {}: Unable to class load the plugin {}", (Object)coreModName, (Object)coreModClass, (Object)cnfe);
            } else {
                FMLLog.log.debug("Skipping root plugin {}", (Object)coreModClass);
            }
        }
        catch (ClassCastException cce) {
            FMLLog.log.error("Coremod {}: The plugin {} is not an implementor of IFMLLoadingPlugin", (Object)coreModName, (Object)coreModClass, (Object)cce);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ie) {
            FMLLog.log.error("Coremod {}: The plugin class {} was not instantiable", (Object)coreModName, (Object)coreModClass, (Object)ie);
        }
        catch (IllegalAccessException iae) {
            FMLLog.log.error("Coremod {}: The plugin class {} was not accessible", (Object)coreModName, (Object)coreModClass, (Object)iae);
        }
        return null;
    }

    public static void injectTransformers(LaunchClassLoader classLoader) {
        Launch.blackboard.put("fml.deobfuscatedEnvironment", deobfuscatedEnvironment);
        tweaker.injectCascadingTweak("net.minecraftforge.fml.common.launcher.FMLDeobfTweaker");
        tweakSorting.put("net.minecraftforge.fml.common.launcher.FMLDeobfTweaker", 1000);
    }

    public static void injectCoreModTweaks(FMLInjectionAndSortingTweaker fmlInjectionAndSortingTweaker) {
        List tweakers = (List)Launch.blackboard.get("Tweaks");
        tweakers.addFirst(fmlInjectionAndSortingTweaker);
        tweakers.addAll(loadPlugins);
    }

    public static void sortTweakList() {
        List tweakers = (List)Launch.blackboard.get("Tweaks");
        ITweaker[] toSort = tweakers.toArray(new ITweaker[0]);
        ToIntFunction<ITweaker> getOrder = o -> o instanceof FMLInjectionAndSortingTweaker ? Integer.MIN_VALUE : (o instanceof FMLPluginWrapper ? ((FMLPluginWrapper)o).sortIndex : tweakSorting.getOrDefault(o.getClass().getName(), 0));
        Arrays.sort(toSort, (o1, o2) -> Ints.saturatedCast((long)((long)getOrder.applyAsInt((ITweaker)o1) - (long)getOrder.applyAsInt((ITweaker)o2))));
        for (int j = 0; j < toSort.length; ++j) {
            tweakers.set(j, toSort[j]);
        }
    }

    public static List<String> getAccessTransformers() {
        return accessTransformers;
    }

    public static void onCrash(StringBuilder builder) {
        if (!ignoredModFiles.isEmpty() || !candidateModFiles.isEmpty()) {
            builder.append("\nWARNING: coremods are present:\n");
            for (String coreMod : transformers.keySet()) {
                builder.append("  ").append(coreMod).append('\n');
            }
            builder.append("Contact their authors BEFORE contacting forge\n\n");
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        candidateModFiles = Lists.newArrayList();
        accessTransformers = Lists.newArrayList();
        rootNames = Sets.newHashSet();
        for (String cls : rootPlugins) {
            rootNames.add(cls.substring(cls.lastIndexOf(46) + 1));
        }
        tweakSorting = Maps.newHashMap();
    }

    private static class FMLPluginWrapper
    implements ITweaker {
        public final String name;
        public final IFMLLoadingPlugin coreModInstance;
        public final List<String> predepends;
        public final File location;
        public final int sortIndex;

        public FMLPluginWrapper(String name, IFMLLoadingPlugin coreModInstance, File location, int sortIndex, String ... predepends) {
            this.name = name;
            this.coreModInstance = coreModInstance;
            this.location = location;
            this.sortIndex = sortIndex;
            this.predepends = Lists.newArrayList((Object[])predepends);
        }

        public String toString() {
            if (this.predepends.isEmpty()) {
                return this.name;
            }
            return String.format("%s {%s}", this.name, this.predepends);
        }

        public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        }

        public void injectIntoClassLoader(LaunchClassLoader classLoader) {
            FMLLog.log.debug("Injecting coremod {} \\{{}\\} class transformers", (Object)this.name, (Object)this.coreModInstance.getClass().getName());
            ArrayList ts = Lists.newArrayList();
            String[] asmTransformerClass = this.coreModInstance.getASMTransformerClass();
            if (asmTransformerClass != null) {
                for (String transformer : asmTransformerClass) {
                    FMLLog.log.trace("Registering transformer {}", (Object)transformer);
                    classLoader.registerTransformer(ASMTransformerWrapper.getTransformerWrapper(classLoader, transformer, this.name));
                    ts.add(transformer);
                }
            }
            if (!rootNames.contains(this.name)) {
                String loc = this.location == null ? "unknown" : this.location.getName();
                transformers.put(this.name + " (" + loc + ")", ts);
            }
            FMLLog.log.debug("Injection complete");
            FMLLog.log.debug("Running coremod plugin for {} {{}}", (Object)this.name, (Object)this.coreModInstance.getClass().getName());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("mcLocation", mcDir);
            data.put("coremodList", loadPlugins);
            data.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
            FMLLog.log.debug("Running coremod plugin {}", (Object)this.name);
            data.put("coremodLocation", this.location);
            this.coreModInstance.injectData(data);
            String setupClass = this.coreModInstance.getSetupClass();
            if (setupClass != null) {
                try {
                    IFMLCallHook call = (IFMLCallHook)Class.forName(setupClass, true, (ClassLoader)classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                    HashMap<String, Object> callData = new HashMap<String, Object>();
                    callData.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
                    callData.put("mcLocation", mcDir);
                    callData.put("classLoader", classLoader);
                    callData.put("coremodLocation", this.location);
                    callData.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                    call.injectData(callData);
                    call.call();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            FMLLog.log.debug("Coremod plugin class {} run successfully", (Object)this.coreModInstance.getClass().getSimpleName());
            String modContainer = this.coreModInstance.getModContainerClass();
            if (modContainer != null) {
                FMLInjectionData.containers.add(modContainer);
            }
        }

        public String getLaunchTarget() {
            return "";
        }

        public String[] getLaunchArguments() {
            return new String[0];
        }
    }
}

