/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.NonNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessTransformer
implements IClassTransformer {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugAccessTransformer", "false"));
    private final Multimap<String, Modifier> modifiers = ArrayListMultimap.create();

    public AccessTransformer() throws IOException {
        this("forge_at.cfg");
    }

    protected AccessTransformer(String rulesFile) throws IOException {
        this.readMapFile(rulesFile);
    }

    AccessTransformer(Class<? extends AccessTransformer> dummyClazz) {
    }

    void readMapFile(String rulesFile) throws IOException {
        File file = new File(rulesFile);
        URL rulesResource = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        this.processATFile(Resources.asCharSource((URL)rulesResource, (Charset)StandardCharsets.UTF_8));
        FMLLog.log.debug("Loaded {} rules from AccessTransformer config file {}", (Object)this.modifiers.size(), (Object)rulesFile);
    }

    protected void processATFile(CharSource rulesResource) throws IOException {
        rulesResource.readLines((LineProcessor)new LineProcessor<Void>(){

            public Void getResult() {
                return null;
            }

            public boolean processLine(@NonNull String input) throws IOException {
                String line = ((String)Iterables.getFirst((Iterable)Splitter.on((char)'#').limit(2).split((CharSequence)input), (Object)"")).trim();
                if (line.isEmpty()) {
                    return true;
                }
                ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)" ").trimResults().split((CharSequence)line));
                if (parts.size() > 3) {
                    throw new RuntimeException("Invalid config file line " + input);
                }
                Modifier m = new Modifier();
                m.setTargetAccess((String)parts.get(0));
                if (parts.size() == 2) {
                    m.modifyClassVisibility = true;
                } else {
                    String nameReference = (String)parts.get(2);
                    int parenIdx = nameReference.indexOf(40);
                    if (parenIdx > 0) {
                        m.desc = nameReference.substring(parenIdx);
                        m.name = nameReference.substring(0, parenIdx);
                    } else {
                        m.name = nameReference;
                    }
                }
                String className = ((String)parts.get(1)).replace('/', '.');
                AccessTransformer.this.modifiers.put((Object)className, (Object)m);
                if (DEBUG) {
                    FMLLog.log.debug("AT RULE: {} {} {} (type {})", (Object)AccessTransformer.this.toBinary(m.targetAccess), (Object)m.name, (Object)m.desc, (Object)className);
                }
                return true;
            }
        });
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!this.modifiers.containsKey((Object)transformedName)) {
            return bytes;
        }
        if (DEBUG) {
            FMLLog.log.debug("Considering all methods and fields on {} ({})", (Object)transformedName, (Object)name);
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Collection mods = this.modifiers.get((Object)transformedName);
        block0: for (Modifier m : mods) {
            if (m.modifyClassVisibility) {
                classNode.access = this.getFixedAccess(classNode.access, m);
                if (DEBUG) {
                    FMLLog.log.debug("Class: {} {} -> {}", (Object)name, (Object)this.toBinary(m.oldAccess), (Object)this.toBinary(m.newAccess));
                }
                for (InnerClassNode innerClass : classNode.innerClasses) {
                    if (!innerClass.name.equals(classNode.name)) continue;
                    innerClass.access = this.getFixedAccess(innerClass.access, m);
                    continue block0;
                }
                continue;
            }
            if (m.desc.isEmpty()) {
                for (FieldNode n : classNode.fields) {
                    if (!n.name.equals(m.name) && !m.name.equals("*")) continue;
                    n.access = this.getFixedAccess(n.access, m);
                    if (DEBUG) {
                        FMLLog.log.debug("Field: {}.{} {} -> {}", (Object)name, (Object)n.name, (Object)this.toBinary(m.oldAccess), (Object)this.toBinary(m.newAccess));
                    }
                    if (m.name.equals("*")) continue;
                    continue block0;
                }
                continue;
            }
            ArrayList nowOverrideable = Lists.newArrayList();
            for (MethodNode n : classNode.methods) {
                if ((!n.name.equals(m.name) || !n.desc.equals(m.desc)) && !m.name.equals("*")) continue;
                n.access = this.getFixedAccess(n.access, m);
                if (!n.name.equals("<init>")) {
                    boolean isNowPrivate;
                    boolean wasPrivate = (m.oldAccess & 2) == 2;
                    boolean bl = isNowPrivate = (m.newAccess & 2) == 2;
                    if (wasPrivate && !isNowPrivate) {
                        nowOverrideable.add(n);
                    }
                }
                if (DEBUG) {
                    FMLLog.log.debug("Method: {}.{}{} {} -> {}", (Object)name, (Object)n.name, (Object)n.desc, (Object)this.toBinary(m.oldAccess), (Object)this.toBinary(m.newAccess));
                }
                if (m.name.equals("*")) continue;
                break;
            }
            if (nowOverrideable.isEmpty()) continue;
            this.replaceInvokeSpecial(classNode, nowOverrideable);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void replaceInvokeSpecial(ClassNode clazz, List<MethodNode> toReplace) {
        for (MethodNode method : clazz.methods) {
            block1: for (AbstractInsnNode insn : method.instructions) {
                if (insn.getOpcode() != 183) continue;
                MethodInsnNode mInsn = (MethodInsnNode)insn;
                for (MethodNode n : toReplace) {
                    if (!n.name.equals(mInsn.name) || !n.desc.equals(mInsn.desc)) continue;
                    mInsn.setOpcode(182);
                    continue block1;
                }
            }
        }
    }

    private String toBinary(int num) {
        return String.format("%16s", Integer.toBinaryString(num)).replace(' ', '0');
    }

    private int getFixedAccess(int access, Modifier target) {
        target.oldAccess = access;
        int t = target.targetAccess;
        int ret = access & 0xFFFFFFF8;
        switch (access & 7) {
            case 2: {
                ret |= t;
                break;
            }
            case 0: {
                ret |= t != 2 ? t : 0;
                break;
            }
            case 4: {
                ret |= t != 2 && t != 0 ? t : 4;
                break;
            }
            case 1: {
                ret |= t != 2 && t != 0 && t != 4 ? t : 1;
                break;
            }
            default: {
                throw new RuntimeException("The fuck?");
            }
        }
        if (target.changeFinal) {
            ret = target.markFinal ? (ret |= 0x10) : (ret &= 0xFFFFFFEF);
        }
        target.newAccess = ret;
        return ret;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: AccessTransformer <JarPath> <MapFile> [MapFile2]... ");
            System.exit(1);
        }
        boolean hasTransformer = false;
        AccessTransformer[] trans = new AccessTransformer[args.length - 1];
        for (int x = 1; x < args.length; ++x) {
            try {
                trans[x - 1] = new AccessTransformer(args[x]);
                hasTransformer = true;
                continue;
            }
            catch (IOException e) {
                System.out.println("Could not read Transformer Map: " + args[x]);
                e.printStackTrace();
            }
        }
        if (!hasTransformer) {
            System.out.println("Could not find a valid transformer to perform");
            System.exit(1);
        }
        File orig = new File(args[0]);
        File temp = new File(args[0] + ".ATBack");
        if (!orig.exists() && !temp.exists()) {
            System.out.println("Could not find target jar: " + String.valueOf(orig));
            System.exit(1);
        }
        if (!orig.renameTo(temp)) {
            System.out.println("Could not rename file: " + String.valueOf(orig) + " -> " + String.valueOf(temp));
            System.exit(1);
        }
        try {
            AccessTransformer.processJar(temp, orig, trans);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (!temp.delete()) {
            System.out.println("Could not delete temp file: " + String.valueOf(temp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(File inFile, File outFile, AccessTransformer[] transformers) throws IOException {
        ZipInputStream inJar = null;
        ZipOutputStream outJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            try {
                outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open output file: " + e.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                    continue;
                }
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                byte[] entryData = entryBuffer.toByteArray();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") && !entryName.startsWith(".")) {
                    ClassNode cls = new ClassNode();
                    ClassReader rdr = new ClassReader(entryData);
                    rdr.accept((ClassVisitor)cls, 0);
                    String name = cls.name.replace('/', '.').replace('\\', '.');
                    for (AccessTransformer trans : transformers) {
                        entryData = trans.transform(name, name, entryData);
                    }
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                outJar.putNextEntry(newEntry);
                outJar.write(entryData);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outJar);
            IOUtils.closeQuietly(inJar);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outJar);
        IOUtils.closeQuietly((InputStream)inJar);
    }

    Multimap<String, Modifier> getModifiers() {
        return this.modifiers;
    }

    boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    static class Modifier {
        public String name = "";
        public String desc = "";
        public int oldAccess = 0;
        public int newAccess = 0;
        public int targetAccess = 0;
        public boolean changeFinal = false;
        public boolean markFinal = false;
        protected boolean modifyClassVisibility;

        Modifier() {
        }

        private void setTargetAccess(String name) {
            if (name.startsWith("public")) {
                this.targetAccess = 1;
            } else if (name.startsWith("private")) {
                this.targetAccess = 2;
            } else if (name.startsWith("protected")) {
                this.targetAccess = 4;
            }
            if (name.endsWith("-f")) {
                this.changeFinal = true;
                this.markFinal = false;
            } else if (name.endsWith("+f")) {
                this.changeFinal = true;
                this.markFinal = true;
            }
        }
    }
}

