/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.asm.transformers.ModAPITransformer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import top.outlands.foundation.TransformerDelegate;

public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of((Object)"jinput.jar", (Object)"lwjgl.jar", (Object)"lwjgl_util.jar", (Object)"rt.jar");
    private LaunchClassLoader mainClassLoader;
    private List<File> sources;
    List<URL> parentURLs = null;

    public ModClassLoader(ClassLoader parent) {
        super(new URL[0], (ClassLoader)null);
        if (parent instanceof LaunchClassLoader) {
            this.mainClassLoader = (LaunchClassLoader)parent;
        }
        this.sources = Lists.newArrayList();
    }

    public void addFile(File modFile) throws MalformedURLException {
        this.mainClassLoader.addURL(modFile.getAbsoluteFile().toURI().toURL());
        this.sources.add(modFile);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.mainClassLoader.loadClass(name);
    }

    public File[] getParentSources() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (URL url : this.mainClassLoader.getSources()) {
                URI uri = url.toURI();
                if (!uri.getScheme().equals("file")) continue;
                files.add(new File(uri));
            }
            return files.toArray(new File[0]);
        }
        catch (URISyntaxException e) {
            FMLLog.log.error("Unable to process our input to locate the minecraft code", (Throwable)e);
            throw new LoaderException(e);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public boolean isDefaultLibrary(File file) {
        String[] prefixes;
        String home = System.getProperty("java.home");
        if (home != null && file.getAbsolutePath().startsWith(home)) {
            return true;
        }
        String name = file.getName();
        if (!name.endsWith(".jar")) {
            return false;
        }
        for (String s : prefixes = new String[]{"asm-", "foundation-", "maven-artifact-", "patchy-", "text2speech-", "mixin-", "launchwrapper-", "asm-all-", "akka-actor_2.11-", "config-", "scala-", "jopt-simple-", "lzma-", "realms-", "httpclient-", "httpcore-", "vecmath-", "trove4j-", "icu4j-core-mojang-", "codecjorbis-", "codecwav-", "libraryjavawound-", "librarylwjglopenal-", "soundsystem-", "netty-all-", "guava-", "commons-lang3-", "commons-compress-", "commons-logging-", "commons-io-", "commons-codec-", "jinput-", "jutils-", "gson-", "authlib-", "log4j-api-", "log4j-core-", "lwjgl-", "lwjgl_util-", "lwjgl3-", "twitch-", "jline-", "jna-", "platform-", "oshi-core-", "netty-", "libraryjavasound-", "fastutil-"}) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public void clearNegativeCacheFor(Set<String> classList) {
        this.mainClassLoader.clearNegativeEntries(classList);
    }

    public ModAPITransformer addModAPITransformer(ASMDataTable dataTable) {
        ModAPITransformer modAPI = new ModAPITransformer();
        TransformerDelegate.registerTransformer((IClassTransformer)modAPI);
        modAPI.initTable(dataTable);
        return modAPI;
    }

    public boolean containsSource(File source) {
        if (this.parentURLs == null) {
            this.parentURLs = Arrays.asList(this.mainClassLoader.getURLs());
        }
        try {
            return this.parentURLs.contains(source.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

