/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    private static final Logger modTrackerLogger = LogManager.getLogger((String)"FML.ModTracker");

    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus2, LoadController controller) {
        bus2.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void modPreinitialization(FMLPreInitializationEvent evt) {
        if (ForgeRegistries.ITEMS == null) {
            throw new RuntimeException("Something horrible went wrong in init, ForgeRegistres didn't create...");
        }
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public fy getDataForWriting(bfb handler, bfd info) {
        fy fmlData = new fy();
        ge modList = new ge();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            fy mod = new fy();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            modList.a((gn)mod);
        }
        fmlData.a("ModList", (gn)modList);
        fy registries = new fy();
        fmlData.a("Registries", (gn)registries);
        FMLLog.log.debug("Gathering id map for writing to world save {}", (Object)info.j());
        for (Map.Entry<nf, ForgeRegistry.Snapshot> e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
            registries.a(e.getKey().toString(), (gn)e.getValue().write());
        }
        return fmlData;
    }

    @Override
    public void readData(bfb handler, bfd info, Map<String, gn> propertyMap, fy tag) {
        if (tag.e("ModList")) {
            ge modList = tag.c("ModList", 10);
            for (int i2 = 0; i2 < modList.c(); ++i2) {
                fy mod = modList.b(i2);
                String modId = mod.l("ModId");
                String modVersion = mod.l("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    modTrackerLogger.error("This world was saved with mod {} which appears to be missing, things may not work well", (Object)modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                modTrackerLogger.info("This world was saved with mod {} version {} and it is now at version {}, things may not work well", (Object)modId, (Object)modVersion, (Object)container.getVersion());
            }
        }
        Multimap<nf, nf> failedElements = null;
        if (tag.e("ModItemData") || tag.e("ItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.e("Registries")) {
            HashMap snapshot = Maps.newHashMap();
            fy regs = tag.p("Registries");
            for (String key : regs.c()) {
                snapshot.put(new nf(key), ForgeRegistry.Snapshot.read(regs.p(key)));
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Forge Mod Loader could not load this save.\n\n").append("There are ").append(failedElements.size()).append(" unassigned registry entries in this save.\n").append("You will not be able to load until they are present again.\n\n");
            failedElements.asMap().forEach((name, entries) -> {
                buf.append("Missing ").append(name).append(":\n");
                entries.forEach(rl2 -> buf.append("    ").append(rl2).append("\n"));
            });
            StartupQuery.notify(buf.toString());
            StartupQuery.abort();
        }
    }

    @Override
    @Nullable
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getResource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

