/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeVersion {
    public static final String MOD_ID = "forge";
    public static final int majorVersion = 14;
    public static final int minorVersion = 23;
    public static final int revisionVersion = 5;
    public static final int buildVersion = 2860;
    public static final String mcVersion = "1.12.2";
    public static final String mcpVersion = "9.42";
    private static Status status = Status.PENDING;
    private static String target = null;
    private static final Logger log = LogManager.getLogger((String)"forge.VersionCheck");
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static Map<ModContainer, CheckResult> results = new ConcurrentHashMap<ModContainer, CheckResult>();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null, null, null);

    public static int getMajorVersion() {
        return 14;
    }

    public static int getMinorVersion() {
        return 23;
    }

    public static int getRevisionVersion() {
        return 5;
    }

    public static int getBuildVersion() {
        return 2860;
    }

    public static Status getStatus() {
        return ForgeVersion.getResult((ModContainer)ForgeModContainer.getInstance()).status;
    }

    @Nullable
    public static String getTarget() {
        CheckResult res = ForgeVersion.getResult(ForgeModContainer.getInstance());
        return res.target != null ? res.target.toString() : null;
    }

    public static String getVersion() {
        return String.format("%d.%d.%d.%d", 14, 23, 5, 2860);
    }

    public static void startVersionCheck() {
        new Thread("Cleanroom Version Check"){

            @Override
            public void run() {
                if (!ForgeModContainer.getConfig().get("version_checking", "Global", true).getBoolean()) {
                    log.info("Global Forge version check system disabled, no further processing.");
                    return;
                }
                for (Map.Entry<ModContainer, URL> entry : ForgeVersion.gatherMods().entrySet()) {
                    ModContainer mod = entry.getKey();
                    if (ForgeModContainer.getConfig().get("version_checking", mod.getModId(), true).getBoolean()) {
                        this.process(mod, entry.getValue());
                        continue;
                    }
                    log.info("[{}] Skipped version check", (Object)mod.getModId());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InputStream openUrlStream(URL url) throws IOException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    URLConnection c2 = currentUrl.openConnection();
                    if (c2 instanceof HttpURLConnection) {
                        HttpURLConnection huc = (HttpURLConnection)c2;
                        huc.setInstanceFollowRedirects(false);
                        int responseCode = huc.getResponseCode();
                        if (responseCode >= 300 && responseCode <= 399) {
                            try {
                                String loc = huc.getHeaderField("Location");
                                currentUrl = new URL(currentUrl, loc);
                                continue;
                            }
                            finally {
                                huc.disconnect();
                            }
                        }
                    }
                    return c2.getInputStream();
                }
                throw new IOException("Too many redirects while trying to fetch " + String.valueOf(url));
            }

            private void process(ModContainer mod, URL url) {
                try {
                    log.info("[{}] Starting version check at {}", (Object)mod.getModId(), (Object)url.toString());
                    Status status = Status.PENDING;
                    ComparableVersion target = null;
                    InputStream con = this.openUrlStream(url);
                    String data = new String(ByteStreams.toByteArray((InputStream)con), "UTF-8");
                    con.close();
                    log.debug("[{}] Received version check data:\n{}", (Object)mod.getModId(), (Object)data);
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String homepage = (String)json.get("homepage");
                    String rec = (String)promos.get("1.12.2-recommended");
                    String lat = (String)promos.get("1.12.2-latest");
                    ComparableVersion current = new ComparableVersion(mod.getVersion());
                    ComparableVersion recommended = null;
                    if (rec != null) {
                        recommended = new ComparableVersion(rec);
                    }
                    ComparableVersion latest = null;
                    if (lat != null) {
                        latest = new ComparableVersion(lat);
                    }
                    if (rec != null) {
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            status = Status.AHEAD;
                            if (lat != null) {
                                diff = current.compareTo(latest);
                                if (diff < 0) {
                                    status = Status.OUTDATED;
                                    target = latest;
                                } else if (diff == 0) {
                                    status = Status.BETA;
                                }
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        if (current.compareTo(latest) < 0) {
                            status = Status.BETA_OUTDATED;
                            target = latest;
                        } else {
                            status = Status.BETA;
                        }
                    } else {
                        status = Status.BETA;
                    }
                    log.info("[{}] Found status: {} Target: {}", (Object)mod.getModId(), (Object)status, (Object)target);
                    LinkedHashMap<ComparableVersion, String> changes = new LinkedHashMap<ComparableVersion, String>();
                    Map tmp = (Map)json.get(ForgeVersion.mcVersion);
                    if (tmp != null) {
                        ArrayList<ComparableVersion> ordered = new ArrayList<ComparableVersion>();
                        for (String key : tmp.keySet()) {
                            ComparableVersion ver = new ComparableVersion(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (ComparableVersion ver : ordered) {
                            changes.put(ver, (String)tmp.get(ver.toString()));
                        }
                    }
                    if (mod instanceof InjectedModContainer) {
                        mod = ((InjectedModContainer)mod).wrappedContainer;
                    }
                    String latestFound = null;
                    if (latest != null && recommended != null) {
                        latestFound = latest.compareTo(recommended) > 0 ? latest.toString() : recommended.toString();
                    } else if (latest != null) {
                        latestFound = latest.toString();
                    } else if (recommended != null) {
                        latestFound = recommended.toString();
                    }
                    results.put(mod, new CheckResult(status, latestFound, target, changes, url.toString(), homepage));
                }
                catch (Exception e) {
                    log.debug("Failed to process update information", (Throwable)e);
                    status = Status.FAILED;
                }
            }
        }.start();
    }

    public static Map<ModContainer, URL> gatherMods() {
        HashMap<ModContainer, URL> ret = new HashMap<ModContainer, URL>();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            URL url = mod.getUpdateUrl();
            if (url == null) continue;
            ret.put(mod, url);
        }
        return ret;
    }

    public static CheckResult getResult(ModContainer mod) {
        CheckResult ret;
        if (mod == null) {
            return PENDING_CHECK;
        }
        if (mod instanceof InjectedModContainer) {
            mod = ((InjectedModContainer)mod).wrappedContainer;
        }
        return (ret = results.get(mod)) == null ? PENDING_CHECK : ret;
    }

    public static CheckResult getCleanResult(ModContainer mod) {
        if (mod == null) {
            return null;
        }
        if (mod instanceof InjectedModContainer) {
            mod = ((InjectedModContainer)mod).wrappedContainer;
        }
        return results.get(mod);
    }

    public static boolean hasOutdatedMods() {
        for (CheckResult results : ForgeVersion.results.values()) {
            if (results.status != Status.OUTDATED) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOutdatedBetaMods() {
        for (CheckResult results : ForgeVersion.results.values()) {
            if (results.status != Status.BETA_OUTDATED) continue;
            return true;
        }
        return false;
    }

    public static class CheckResult {
        public final Status status;
        @Nullable
        public final String latestFound;
        @Nullable
        public final ComparableVersion target;
        public final Map<ComparableVersion, String> changes;
        @Nullable
        public final String url;
        @Nullable
        public final String homepage;

        private CheckResult(Status status, @Nullable String latestFound, @Nullable ComparableVersion target, @Nullable Map<ComparableVersion, String> changes, @Nullable String url, @Nullable String homepage) {
            this.status = status;
            this.latestFound = latestFound;
            this.target = target;
            this.changes = changes == null ? Collections.emptyMap() : Collections.unmodifiableMap(changes);
            this.url = url;
            this.homepage = homepage;
        }
    }

    public static enum Status {
        PENDING(0, true),
        FAILED(1, true),
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD(7, false),
        BETA(6, false),
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean animated;

        private Status() {
            this(0, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this != UP_TO_DATE;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }
}

