/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.FancyMissingModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.AnimationStateMachine;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.FMLLog;

public class ModelLoaderRegistry {
    private static final Set<ICustomModelLoader> loaders = Sets.newHashSet();
    private static final Map<nf, IModel> cache = Maps.newHashMap();
    private static final Deque<nf> loadingModels = Queues.newArrayDeque();
    private static final Set<nf> textures = Sets.newHashSet();
    private static final Map<nf, nf> aliases = Maps.newHashMap();
    private static cep manager;

    public static void registerLoader(ICustomModelLoader loader) {
        loaders.add(loader);
        ((cen)bib.z().O()).a((ceq)loader);
    }

    public static boolean loaded(nf location) {
        return cache.containsKey(location);
    }

    public static nf getActualLocation(nf location) {
        if (location instanceof cgd) {
            return location;
        }
        if (location.a().startsWith("builtin/")) {
            return location;
        }
        return new nf(location.b(), "models/" + location.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IModel getModel(nf location) throws Exception {
        IModel model;
        IModel cached = cache.get(location);
        if (cached != null) {
            return cached;
        }
        for (Object loading : loadingModels) {
            if (location.getClass() != loading.getClass() || !location.equals(loading)) continue;
            throw new LoaderException("circular model dependencies, stack: [" + Joiner.on((String)", ").join(loadingModels) + "]");
        }
        loadingModels.addLast(location);
        try {
            nf aliased = aliases.get(location);
            if (aliased != null) {
                Object loading;
                loading = ModelLoaderRegistry.getModel(aliased);
                return loading;
            }
            nf actual = ModelLoaderRegistry.getActualLocation(location);
            ICustomModelLoader accepted = null;
            for (ICustomModelLoader loader : loaders) {
                try {
                    if (!loader.accepts(actual)) continue;
                    if (accepted != null) {
                        throw new LoaderException(String.format("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location));
                    }
                    accepted = loader;
                }
                catch (Exception e) {
                    throw new LoaderException(String.format("Exception checking if model %s can be loaded with loader %s, skipping", location, loader), e);
                }
            }
            if (accepted == null) {
                if (ModelLoader.VariantLoader.INSTANCE.accepts(actual)) {
                    accepted = ModelLoader.VariantLoader.INSTANCE;
                } else if (ModelLoader.VanillaLoader.INSTANCE.accepts(actual)) {
                    accepted = ModelLoader.VanillaLoader.INSTANCE;
                }
            }
            if (accepted == null) {
                throw new LoaderException("no suitable loader found for the model " + String.valueOf(location) + ", skipping");
            }
            try {
                model = accepted.loadModel(actual);
            }
            catch (Exception e) {
                throw new LoaderException(String.format("Exception loading model %s with loader %s, skipping", location, accepted), e);
            }
            if (model == ModelLoaderRegistry.getMissingModel()) {
                throw new LoaderException(String.format("Loader %s returned missing model while loading model %s", accepted, location));
            }
            if (model == null) {
                throw new LoaderException(String.format("Loader %s returned null while loading model %s", accepted, location));
            }
            textures.addAll(model.getTextures());
        }
        finally {
            nf popLoc = loadingModels.removeLast();
            if (popLoc != location) {
                throw new IllegalStateException("Corrupted loading model stack: " + String.valueOf(popLoc) + " != " + String.valueOf(location));
            }
        }
        cache.put(location, model);
        for (nf dep : model.getDependencies()) {
            ModelLoaderRegistry.getModelOrMissing(dep);
        }
        return model;
    }

    public static IModel getModelOrMissing(nf location) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            return ModelLoaderRegistry.getMissingModel(location, e);
        }
    }

    public static IModel getModelOrLogError(nf location, String error) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            FMLLog.log.error(error, (Throwable)e);
            return ModelLoaderRegistry.getMissingModel(location, e);
        }
    }

    public static IModel getMissingModel() {
        ModelLoader loader = ModelLoader.VanillaLoader.INSTANCE.getLoader();
        if (loader == null) {
            throw new IllegalStateException("Using ModelLoaderRegistry too early.");
        }
        return loader.getMissingModel();
    }

    static IModel getMissingModel(nf location, Throwable cause) {
        FancyMissingModel model = new FancyMissingModel(ModelLoaderRegistry.getMissingModel(), location.toString());
        textures.addAll(model.getTextures());
        return model;
    }

    static void addAlias(nf from, nf to) {
        aliases.put(from, to);
    }

    public static void clearModelCache(cep manager) {
        ModelLoaderRegistry.manager = manager;
        aliases.clear();
        textures.clear();
        cache.clear();
        cache.put(new nf("minecraft:builtin/generated"), ItemLayerModel.INSTANCE);
        cache.put(new nf("minecraft:block/builtin/generated"), ItemLayerModel.INSTANCE);
        cache.put(new nf("minecraft:item/builtin/generated"), ItemLayerModel.INSTANCE);
    }

    static Iterable<nf> getTextures() {
        return textures;
    }

    public static IAnimationStateMachine loadASM(nf location, ImmutableMap<String, ITimeValue> customParameters) {
        return AnimationStateMachine.load(manager, location, customParameters);
    }

    static {
        ModelLoaderRegistry.registerLoader(B3DLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(OBJLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ModelFluid.FluidLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ItemLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(MultiLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ModelDynBucket.LoaderDynBucket.INSTANCE);
    }

    public static class LoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoaderException(String message) {
            super(message);
        }

        public LoaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

