/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.blay09.mods.waystones.api.requirement.VariableResolver;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.api.requirement.WarpRequirementsContext;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.requirement.CombinedRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredCondition;
import net.blay09.mods.waystones.requirement.ConfiguredRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredRequirementModifier;
import net.blay09.mods.waystones.requirement.NoRequirement;
import net.blay09.mods.waystones.requirement.RequirementRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class WarpRequirementsContextImpl
implements WarpRequirementsContext {
    private final Map<ResourceLocation, WarpRequirement> requirements = new HashMap<ResourceLocation, WarpRequirement>();
    private final WaystoneTeleportContext context;

    public WarpRequirementsContextImpl(WaystoneTeleportContext context) {
        this.context = context;
    }

    public <T extends WarpRequirement, P> void apply(ConfiguredRequirementModifier<T, P> configuredModifier) {
        for (ConfiguredCondition<?> condition : configuredModifier.conditions()) {
            if (this.matchesCondition(condition)) continue;
            return;
        }
        ConfiguredRequirement<T, P> requirement = configuredModifier.requirement();
        RequirementFunction<T, P> modifier = requirement.modifier();
        P parameters = requirement.parameters();
        WarpRequirement existing = this.requirements.get(modifier.getRequirementType());
        if (existing == null) {
            existing = RequirementRegistry.getRequirementType(modifier.getRequirementType()).createInstance();
        }
        this.requirements.put(modifier.getRequirementType(), modifier.apply(existing, this, parameters));
    }

    @Override
    public float getContextValue(ResourceLocation id) {
        VariableResolver resolver = RequirementRegistry.getVariableResolver(id);
        if (resolver != null) {
            return resolver.resolve(this.context);
        }
        Entity entity = this.context.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return (float)PlayerWaystoneManager.getCooldownMillisLeft(player, id) / 1000.0f;
        }
        return 0.0f;
    }

    @Override
    public <P> boolean matchesCondition(ConfiguredCondition<P> configuredCondition) {
        return configuredCondition.resolver().matches(this.context, configuredCondition.parameters());
    }

    public WarpRequirement resolve() {
        if (this.requirements.isEmpty()) {
            return NoRequirement.INSTANCE;
        }
        if (this.requirements.size() == 1) {
            return this.requirements.values().iterator().next();
        }
        return new CombinedRequirement(this.requirements.values());
    }
}

