/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RemoveWaystoneButton
extends Button
implements ITooltipProvider {
    private static final ResourceLocation CANCEL_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/cancel");
    private final List<Component> tooltip;
    private final List<Component> activeTooltip;
    private final int visibleRegionStart;
    private final int visibleRegionHeight;
    private static boolean shiftGuard;

    public RemoveWaystoneButton(int x, int y, int visibleRegionStart, int visibleRegionHeight, Waystone waystone, Button.OnPress pressable) {
        super(x, y, 18, 18, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
        this.visibleRegionStart = visibleRegionStart;
        this.visibleRegionHeight = visibleRegionHeight;
        this.tooltip = Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.waystones.waystone_selection.hold_shift_to_delete")});
        this.activeTooltip = Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.waystones.waystone_selection.click_to_delete")});
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL || WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
            MutableComponent component = Component.translatable((String)"gui.waystones.waystone_selection.deleting_global_for_all");
            component.withStyle(ChatFormatting.DARK_RED);
            this.tooltip.add((Component)component);
            this.activeTooltip.add((Component)component);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            shiftGuard = true;
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        boolean shiftDown = Screen.hasShiftDown();
        if (!shiftDown) {
            shiftGuard = false;
        }
        boolean bl = this.active = !shiftGuard && shiftDown;
        if (mouseY >= this.visibleRegionStart && mouseY < this.visibleRegionStart + this.visibleRegionHeight) {
            if (this.isHovered && this.active) {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                guiGraphics.setColor(0.5f, 0.5f, 0.5f, 0.5f);
            }
            guiGraphics.blitSprite(CANCEL_SPRITE, this.getX(), this.getY(), 13, 13);
        }
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.isHovered;
    }

    @Override
    public List<Component> getTooltipComponents() {
        return this.active ? this.activeTooltip : this.tooltip;
    }
}

