/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.upgrades.EntityMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyCondition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeContainer;

public class AlchemyUpgradeTab
extends UpgradeSettingsTab<AlchemyUpgradeContainer> {
    public static final ButtonDefinition.Toggle<AlchemyCondition> ALCHEMY_CONDITION = ButtonDefinitions.createToggleButtonDefinition(Map.of(AlchemyCondition.NEVER, GuiHelper.getButtonStateData(new UV(240, 0), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_never"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.ALWAYS, GuiHelper.getButtonStateData(new UV(128, 64), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_always"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.ON_FIRE, GuiHelper.getButtonStateData(new UV(176, 80), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_on_fire"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.UNDER_WATER, GuiHelper.getButtonStateData(new UV(192, 80), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_under_water"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.FALLING, GuiHelper.getButtonStateData(new UV(208, 80), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_falling"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.SPRINTING, GuiHelper.getButtonStateData(new UV(224, 80), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_sprinting"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.NEGATIVE_EFFECT, GuiHelper.getButtonStateData(new UV(240, 80), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_negative_effect"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.MINING, GuiHelper.getButtonStateData(new UV(64, 64), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_mining"), Dimension.SQUARE_16, new Position(1, 1)), AlchemyCondition.HURT, GuiHelper.getButtonStateData(new UV(96, 16), TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition_hurt"), Dimension.SQUARE_16, new Position(1, 1))));
    private static final TextureBlitData DISABLED_CONDITION = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(240, 64), Dimension.SQUARE_16);
    public static final ButtonDefinition.Toggle<Boolean> ANY_EFFECT_MISSING = ButtonDefinitions.createToggleButtonDefinition(Map.of(true, GuiHelper.getButtonStateData(new UV(176, 96), TranslationHelper.INSTANCE.translUpgradeButton("any_effect_missing"), Dimension.SQUARE_16, new Position(1, 1)), false, GuiHelper.getButtonStateData(new UV(48, 80), TranslationHelper.INSTANCE.translUpgradeButton("all_effects_missing"), Dimension.SQUARE_16, new Position(1, 1))));
    public static final ButtonDefinition.Toggle<Boolean> MATCH_DURATION = ButtonDefinitions.createToggleButtonDefinition(Map.of(true, GuiHelper.getButtonStateData(new UV(192, 96), TranslationHelper.INSTANCE.translUpgradeButton("match_duration"), Dimension.SQUARE_16, new Position(1, 1)), false, GuiHelper.getButtonStateData(new UV(208, 96), TranslationHelper.INSTANCE.translUpgradeButton("ignore_duration"), Dimension.SQUARE_16, new Position(1, 1))));
    public static final ButtonDefinition.Toggle<Boolean> MATCH_AMPLIFIER = ButtonDefinitions.createToggleButtonDefinition(Map.of(true, GuiHelper.getButtonStateData(new UV(224, 96), TranslationHelper.INSTANCE.translUpgradeButton("match_amplifier"), Dimension.SQUARE_16, new Position(1, 1)), false, GuiHelper.getButtonStateData(new UV(240, 96), TranslationHelper.INSTANCE.translUpgradeButton("ignore_amplifier"), Dimension.SQUARE_16, new Position(1, 1))));
    public static final ButtonDefinition.Toggle<EntityMatch> ENTITY_MATCH = ButtonDefinitions.createToggleButtonDefinition(Map.of(EntityMatch.ENTITIES, GuiHelper.getButtonStateData(new UV(128, 96), TranslationHelper.INSTANCE.translUpgradeButton("entity_match_entities"), Dimension.SQUARE_16, new Position(1, 1)), EntityMatch.PLAYERS_AND_ENTITIES, GuiHelper.getButtonStateData(new UV(144, 96), TranslationHelper.INSTANCE.translUpgradeButton("entity_match_players_and_entities"), Dimension.SQUARE_16, new Position(1, 1)), EntityMatch.PLAYERS, GuiHelper.getButtonStateData(new UV(160, 96), TranslationHelper.INSTANCE.translUpgradeButton("entity_match_players"), Dimension.SQUARE_16, new Position(1, 1))));
    private static final int TOP_POS = 24;
    private final int buttonYOffset;

    protected AlchemyUpgradeTab(final AlchemyUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen, MutableComponent tabLabel, Component closedTooltip, boolean topButtonsOffset) {
        super(upgradeContainer, position, screen, (Component)tabLabel, closedTooltip);
        this.buttonYOffset = topButtonsOffset ? 20 : 0;
        for (int i = 0; i < upgradeContainer.getSlots().size(); ++i) {
            final int slot = i;
            this.addHideableChild(new ToggleButton<AlchemyCondition>(new Position(this.x + 21 + i % 2 * 36, this.y + 24 + this.buttonYOffset + i / 2 * 20), ALCHEMY_CONDITION, button -> ((AlchemyUpgradeContainer)this.getContainer()).toggleCondition(slot), () -> ((AlchemyUpgradeContainer)this.getContainer()).getCondition(slot)){

                @Override
                protected List<Component> getTooltip(ToggleButton.StateData data) {
                    if (((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).hasNoFilter(slot)) {
                        return Collections.emptyList();
                    }
                    float value = upgradeContainer.getValue(slot);
                    if (value < 0.0f) {
                        return super.getTooltip(data);
                    }
                    ArrayList<Component> tooltip = new ArrayList<Component>(super.getTooltip(data));
                    Component component = (Component)tooltip.getFirst();
                    if (this.getState.get() == AlchemyCondition.HURT) {
                        tooltip.set(0, (Component)Component.translatable((String)component.getString(), (Object[])new Object[]{Component.literal((String)(Math.round(value * 100.0f) + "%")).withStyle(ChatFormatting.DARK_GREEN)}));
                        tooltip.add((Component)Component.translatable((String)TranslationHelper.INSTANCE.translUpgradeButton("alchemy_condition.value_controls")).withStyle(ChatFormatting.DARK_GRAY));
                    }
                    return tooltip;
                }

                public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
                    if (AlchemyUpgradeTab.this.isOpen && this.getState.get() == AlchemyCondition.HURT && this.isMouseOver(mouseX, mouseY)) {
                        if (scrollY > 0.0) {
                            ((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).setValue(slot, Math.min(((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).getValue(slot) + 0.05f, 1.0f));
                        } else if (scrollY < 0.0) {
                            ((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).setValue(slot, Math.max(((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).getValue(slot) - 0.05f, 0.0f));
                        }
                        return true;
                    }
                    return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
                }

                @Override
                protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    if (((AlchemyUpgradeContainer)AlchemyUpgradeTab.this.getContainer()).hasNoFilter(slot)) {
                        GuiHelper.blit(guiGraphics, this.x, this.y, DISABLED_CONDITION);
                    } else {
                        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                    }
                }
            });
        }
    }

    @Override
    protected void moveSlotsToTab() {
        int slotIndex = 0;
        for (Slot slot : ((AlchemyUpgradeContainer)this.getContainer()).getSlots()) {
            slot.x = this.x - ((StorageScreenBase)this.screen).getGuiLeft() + 4 + slotIndex % 2 * 36;
            slot.y = this.y - ((StorageScreenBase)this.screen).getGuiTop() + 24 + this.buttonYOffset + 1 + slotIndex / 2 * 20;
            ++slotIndex;
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
        if (((AlchemyUpgradeContainer)this.getContainer()).isOpen()) {
            for (Slot slot : ((AlchemyUpgradeContainer)this.getContainer()).getSlots()) {
                GuiHelper.renderSlotsBackground(guiGraphics, ((StorageScreenBase)this.screen).getGuiLeft() + slot.x - 1, ((StorageScreenBase)this.screen).getGuiTop() + slot.y - 1, 1, 1);
            }
        }
    }

    public static class Advanced
    extends AlchemyUpgradeTab {
        public Advanced(AlchemyUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen) {
            super(upgradeContainer, position, screen, TranslationHelper.INSTANCE.translUpgrade("advanced_alchemy", new Object[0]), TranslationHelper.INSTANCE.translUpgradeTooltip("advanced_alchemy"), true);
            this.addHideableChild(new ToggleButton<Boolean>(new Position(this.x + 3, this.y + 24), ANY_EFFECT_MISSING, button -> ((AlchemyUpgradeContainer)this.getContainer()).toggleMatchAll(), () -> ((AlchemyUpgradeContainer)this.getContainer()).shouldMatchAll()));
            this.addHideableChild(new ToggleButton<Boolean>(new Position(this.x + 3 + 18, this.y + 24), MATCH_DURATION, button -> ((AlchemyUpgradeContainer)this.getContainer()).toggleMatchDuration(), () -> ((AlchemyUpgradeContainer)this.getContainer()).shouldMatchDuration()));
            this.addHideableChild(new ToggleButton<Boolean>(new Position(this.x + 3 + 36, this.y + 24), MATCH_AMPLIFIER, button -> ((AlchemyUpgradeContainer)this.getContainer()).toggleMatchAmplifier(), () -> ((AlchemyUpgradeContainer)this.getContainer()).shouldMatchAmplifier()));
            if (((AlchemyUpgradeContainer)this.getContainer()).hasEntityMatchOption()) {
                this.addHideableChild(new ToggleButton<EntityMatch>(new Position(this.x + 3 + 54, this.y + 24), ENTITY_MATCH, button -> ((AlchemyUpgradeContainer)this.getContainer()).toggleEntityMatch(), () -> ((AlchemyUpgradeContainer)this.getContainer()).getEntityMatch()));
            }
        }
    }

    public static class Basic
    extends AlchemyUpgradeTab {
        public Basic(AlchemyUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen) {
            super(upgradeContainer, position, screen, TranslationHelper.INSTANCE.translUpgrade("alchemy", new Object[0]), TranslationHelper.INSTANCE.translUpgradeTooltip("alchemy"), false);
        }
    }
}

