/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPayload;

public record RequestBackpackInventoryContentsPayload(UUID backpackUuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestBackpackInventoryContentsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedBackpacks.getRL("request_backpack_inventory_contents"));
    public static final StreamCodec<ByteBuf, RequestBackpackInventoryContentsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RequestBackpackInventoryContentsPayload::backpackUuid, RequestBackpackInventoryContentsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestBackpackInventoryContentsPayload payload, IPayloadContext context) {
        Player player;
        Tag upgradeNbt;
        CompoundTag backpackContents = BackpackStorage.get().getOrCreateBackpackContents(payload.backpackUuid);
        CompoundTag inventoryContents = new CompoundTag();
        Tag inventoryNbt = backpackContents.get("inventory");
        if (inventoryNbt != null) {
            inventoryContents.put("inventory", inventoryNbt);
        }
        if ((upgradeNbt = backpackContents.get("upgradeInventory")) != null) {
            inventoryContents.put("upgradeInventory", upgradeNbt);
        }
        if ((player = context.player()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BackpackContentsPayload(payload.backpackUuid, inventoryContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

