/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.shaderpack;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.features.FeatureFlags;
import net.irisshaders.iris.gl.texture.TextureDefinition;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gui.FeatureMissingErrorScreen;
import net.irisshaders.iris.gui.screen.ShaderPackScreen;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.pathways.colorspace.ColorSpace;
import net.irisshaders.iris.shaderpack.DimensionId;
import net.irisshaders.iris.shaderpack.IdMap;
import net.irisshaders.iris.shaderpack.ImageInformation;
import net.irisshaders.iris.shaderpack.IrisDefines;
import net.irisshaders.iris.shaderpack.LanguageMap;
import net.irisshaders.iris.shaderpack.include.AbsolutePackPath;
import net.irisshaders.iris.shaderpack.include.IncludeGraph;
import net.irisshaders.iris.shaderpack.include.IncludeProcessor;
import net.irisshaders.iris.shaderpack.include.ShaderPackSourceNames;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.option.OrderBackedProperties;
import net.irisshaders.iris.shaderpack.option.ProfileSet;
import net.irisshaders.iris.shaderpack.option.ShaderPackOptions;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuContainer;
import net.irisshaders.iris.shaderpack.option.values.MutableOptionValues;
import net.irisshaders.iris.shaderpack.parsing.BooleanParser;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import net.irisshaders.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSetInterface;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import net.irisshaders.iris.shaderpack.texture.CustomTextureData;
import net.irisshaders.iris.shaderpack.texture.TextureFilteringData;
import net.irisshaders.iris.shaderpack.texture.TextureStage;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class ShaderPack {
    private static final ByteBufAllocator ALLOC = PooledByteBufAllocator.DEFAULT;
    private static final Gson GSON = new Gson();
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private static final int PARALLELISM = Math.min(Runtime.getRuntime().availableProcessors() * 8, 256);
    private static final ForkJoinPool TEXTURE_LOAD_EXECUTOR = new ForkJoinPool(PARALLELISM, ForkJoinPool.defaultForkJoinWorkerThreadFactory, (t, e) -> Iris.logger.error("Texture loader thread failed", e), true);
    private static final int MAX_CONCURRENT_LOADS = Math.min(Integer.MAX_VALUE, CORES * 4);
    private static final int LOAD_TIMEOUT = 2;
    private static final String DIMENSION_CONFIG_NAME = "dimension.properties";
    private static String fileName;
    private static final LoadingCache<PreprocessKey, String> PREPROCESS_CACHE;
    private final Map<TextureDefinition, CompletableFuture<CustomTextureData>> textureCache = new ConcurrentHashMap<TextureDefinition, CompletableFuture<CustomTextureData>>();
    private final Semaphore textureLoadSemaphore = new Semaphore(MAX_CONCURRENT_LOADS);
    public final CustomUniforms.Builder customUniforms;
    private final ProgramSet base;
    private final Map<NamespacedId, ProgramSetInterface> overrides;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, CustomTextureData> irisCustomTextureDataMap = new Object2ObjectOpenHashMap();
    private final CustomTextureData customNoiseTexture;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final String profileInfo;
    private final List<ImageInformation> irisCustomImages;
    private final Set<FeatureFlags> activeFeatures;
    private final Function<AbsolutePackPath, String> sourceProvider;
    private final ShaderProperties shaderProperties;
    private final List<String> dimensionIds;
    private Map<NamespacedId, String> dimensionMap;

    public ShaderPack(Path root, Map<String, String> changedConfigs, ImmutableList<StringPair> environmentDefines, boolean isZip) throws IOException, IllegalStateException {
        Objects.requireNonNull(root);
        ArrayList<StringPair> envDefines1 = new ArrayList<StringPair>((Collection<StringPair>)environmentDefines);
        envDefines1.addAll((Collection<StringPair>)IrisDefines.createIrisReplacements());
        environmentDefines = ImmutableList.copyOf(envDefines1);
        ImmutableList.Builder starts = ImmutableList.builder();
        ImmutableList<String> potentialFileNames = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/"), potentialFileNames);
        this.dimensionIds = new ArrayList<String>();
        boolean[] hasDimensionIds = new boolean[]{false};
        List dimensionIdCreator = ShaderPack.loadProperties(root, (Iterable<StringPair>)environmentDefines).map(dimensionProperties -> {
            hasDimensionIds[0] = !dimensionProperties.isEmpty();
            this.dimensionMap = ShaderPack.parseDimensionMap(dimensionProperties);
            return this.parseDimensionIds((Properties)dimensionProperties);
        }).orElseGet(ArrayList::new);
        if (!hasDimensionIds[0]) {
            this.dimensionMap = new Object2ObjectArrayMap();
            if (Files.exists(root.resolve("world0"), new LinkOption[0])) {
                dimensionIdCreator.add("world0");
                this.dimensionMap.putIfAbsent(DimensionId.OVERWORLD, "world0");
                this.dimensionMap.putIfAbsent(new NamespacedId("*", "*"), "world0");
            }
            if (Files.exists(root.resolve("world-1"), new LinkOption[0])) {
                dimensionIdCreator.add("world-1");
                this.dimensionMap.putIfAbsent(DimensionId.NETHER, "world-1");
            }
            if (Files.exists(root.resolve("world1"), new LinkOption[0])) {
                dimensionIdCreator.add("world1");
                this.dimensionMap.putIfAbsent(DimensionId.END, "world1");
            }
        }
        for (String id : dimensionIdCreator) {
            if (!ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/" + id), potentialFileNames)) continue;
            this.dimensionIds.add(id);
        }
        IncludeGraph graph = new IncludeGraph(root, (ImmutableList<AbsolutePackPath>)starts.build(), isZip);
        if (!graph.getFailures().isEmpty()) {
            graph.getFailures().forEach((path, error) -> Iris.logger.error("{}", error.toString()));
            throw new IOException("Failed to resolve some #include directives");
        }
        this.languageMap = new LanguageMap(root.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(graph, changedConfigs);
        graph = this.shaderPackOptions.getIncludes();
        ArrayList<StringPair> finalEnvironmentDefines = new ArrayList<StringPair>(List.copyOf(environmentDefines));
        for (FeatureFlags flag2 : FeatureFlags.values()) {
            if (!flag2.isUsable()) continue;
            finalEnvironmentDefines.add(new StringPair("IRIS_FEATURE_" + flag2.name(), ""));
        }
        this.shaderProperties = ShaderPack.loadPropertiesAsString(root, "shaders.properties", (Iterable<StringPair>)environmentDefines).map(source -> new ShaderProperties((String)source, this.shaderPackOptions, (Iterable<StringPair>)finalEnvironmentDefines)).orElseGet(ShaderProperties::empty);
        this.activeFeatures = new HashSet<FeatureFlags>();
        this.shaderProperties.getRequiredFeatureFlags().forEach(flag -> this.activeFeatures.add(FeatureFlags.getValue(flag)));
        this.shaderProperties.getOptionalFeatureFlags().forEach(flag -> this.activeFeatures.add(FeatureFlags.getValue(flag)));
        if (!this.activeFeatures.contains((Object)FeatureFlags.SSBO) && !this.shaderProperties.getBufferObjects().isEmpty()) {
            throw new IllegalStateException("An SSBO is being used, but the feature flag for SSBO's hasn't been set! Please set either a requirement or check for the SSBO feature using \"iris.features.required/optional = ssbo\".");
        }
        if (!this.activeFeatures.contains((Object)FeatureFlags.CUSTOM_IMAGES) && !this.shaderProperties.getIrisCustomImages().isEmpty()) {
            throw new IllegalStateException("Custom images are being used, but the feature flag for custom images hasn't been set! Please set either a requirement or check for custom images' feature flag using \"iris.features.required/optional = CUSTOM_IMAGES\".");
        }
        List<FeatureFlags> invalidFlagList = this.shaderProperties.getRequiredFeatureFlags().stream().filter(FeatureFlags::isInvalid).map(FeatureFlags::getValue).collect(Collectors.toList());
        if (!invalidFlagList.isEmpty() && Minecraft.getInstance().screen instanceof ShaderPackScreen) {
            MutableComponent component = Component.translatable((String)"iris.unsupported.pack.description", (Object[])new Object[]{FeatureFlags.getInvalidStatus(invalidFlagList), invalidFlagList.stream().map(FeatureFlags::getHumanReadableName).collect(Collectors.joining(", ", ": ", "."))});
            if (SystemUtils.IS_OS_MAC) {
                component = component.append((Component)Component.translatable((String)"iris.unsupported.pack.macos"));
            }
            Minecraft.getInstance().setScreen((Screen)new FeatureMissingErrorScreen(Minecraft.getInstance().screen, (Component)Component.translatable((String)"iris.unsupported.pack"), (Component)component));
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(false);
        }
        ArrayList newEnvDefines = new ArrayList(environmentDefines);
        if (this.shaderProperties.supportsColorCorrection().orElse(false)) {
            Arrays.stream(ColorSpace.values()).forEach(space -> newEnvDefines.add(new StringPair("COLOR_SPACE_" + space.name(), String.valueOf(space.ordinal()))));
        }
        this.shaderProperties.getOptionalFeatureFlags().stream().filter(flag -> !FeatureFlags.isInvalid(flag)).forEach(flag -> newEnvDefines.add(new StringPair("IRIS_FEATURE_" + flag, "")));
        environmentDefines = ImmutableList.copyOf(newEnvDefines);
        ProfileSet profiles = ProfileSet.fromTree(this.shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        ProfileSet.ProfileResult profile = profiles.scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList disabledPrograms = new ArrayList();
        profile.current.ifPresent(p -> disabledPrograms.addAll(p.disabledPrograms));
        this.shaderProperties.getConditionallyEnabledPrograms().forEach((program, option) -> {
            if (!BooleanParser.parse(option, this.shaderPackOptions.getOptionValues())) {
                disabledPrograms.add(program);
            }
        });
        this.menuContainer = new OptionMenuContainer(this.shaderProperties, this.shaderPackOptions, profiles);
        String profileName = profile.current.map(p -> p.name).orElse("Custom");
        MutableOptionValues profileOptions = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), profile.current.map(p -> p.optionValues).orElse(new HashMap()));
        int userOptionsChanged = this.shaderPackOptions.getOptionValues().getOptionsChanged() - profileOptions.getOptionsChanged();
        this.profileInfo = String.format("Profile: %s (+%d %s changed)", profileName, userOptionsChanged, userOptionsChanged == 1 ? "option" : "options");
        Iris.logger.info(this.profileInfo);
        IncludeProcessor includeProcessor = new IncludeProcessor(graph);
        ImmutableList finalEnvironmentDefines1 = environmentDefines;
        this.sourceProvider = arg_0 -> ShaderPack.lambda$new$14(disabledPrograms, includeProcessor, (Iterable)finalEnvironmentDefines1, arg_0);
        String defaultDimensionPath = this.dimensionMap.getOrDefault(new NamespacedId("*", "*"), "");
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/" + defaultDimensionPath), this.sourceProvider, this.shaderProperties, this);
        this.overrides = new HashMap<NamespacedId, ProgramSetInterface>();
        this.idMap = new IdMap(root, this.shaderPackOptions, (Iterable<StringPair>)environmentDefines);
        CompletableFuture noiseFuture = this.shaderProperties.getNoiseTexturePath().map(path -> this.readTextureAsync(root, new TextureDefinition.PNGDefinition((String)path))).orElseGet(() -> CompletableFuture.completedFuture(null));
        this.customNoiseTexture = (CustomTextureData)((CompletableFuture)noiseFuture.exceptionally(ex -> {
            Iris.logger.error("Failed to load noise texture", (Throwable)ex);
            return this.createFallbackTexture(new TextureDefinition.PNGDefinition("noise.png"));
        })).join();
        this.shaderProperties.getCustomTextures().forEach((stage, textures) -> {
            Object2ObjectOpenHashMap futures = new Object2ObjectOpenHashMap();
            textures.forEach((arg_0, arg_1) -> this.lambda$new$19(root, (Object2ObjectMap)futures, arg_0, arg_1));
            CompletableFuture.allOf((CompletableFuture[])futures.values().toArray((Object[])new CompletableFuture[0])).thenRun(() -> this.lambda$new$21((Object2ObjectMap)futures, stage));
        });
        this.shaderProperties.getIrisCustomTextures().forEach((name, def) -> {
            CompletableFuture<CustomTextureData> future = ((CompletableFuture)this.readTextureAsync(root, (TextureDefinition)def).exceptionally(ex -> {
                Iris.logger.error("Failed to load Iris texture {}: {}", name, def.getName(), ex);
                return this.createFallbackTexture((TextureDefinition)def);
            })).completeOnTimeout(this.createFallbackTexture((TextureDefinition)def), 2L, TimeUnit.SECONDS);
            this.irisCustomTextureDataMap.put(name, (Object)future.join());
        });
        this.irisCustomImages = this.shaderProperties.getIrisCustomImages();
        this.customUniforms = this.shaderProperties.getCustomUniforms();
    }

    public static String getFileName() {
        return fileName;
    }

    private CompletableFuture<CustomTextureData> readTextureAsync(Path root, TextureDefinition definition) {
        return this.textureCache.computeIfAbsent(definition, def -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                this.textureLoadSemaphore.acquire();
                CustomTextureData customTextureData = this.loadTextureSync(root, (TextureDefinition)def);
                return customTextureData;
            }
            catch (IOException | InterruptedException e) {
                throw new CompletionException(e);
            }
            finally {
                this.textureLoadSemaphore.release();
            }
        }, TEXTURE_LOAD_EXECUTOR).exceptionally(ex -> {
            Iris.logger.error("Failed to load texture: {}", def.getName(), ex);
            return this.createFallbackTexture((TextureDefinition)def);
        })).completeOnTimeout(this.createFallbackTexture((TextureDefinition)def), 2L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomTextureData loadTextureSync(Path root, TextureDefinition definition) throws IOException {
        String path = definition.getName();
        if (path.contains(":")) {
            return this.handleResourceLocation(path);
        }
        Path resolvedPath = root.resolve(this.normalizePath(path));
        TextureFilteringData filtering = this.resolveFilteringData(root, path, definition);
        ByteBuf buffer = null;
        try {
            byte[] content = Files.readAllBytes(resolvedPath);
            buffer = ALLOC.buffer(content.length);
            buffer.writeBytes(content);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.getBytes(buffer.readerIndex(), data);
            CustomTextureData customTextureData = this.createTextureData(definition, filtering, data);
            return customTextureData;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private CustomTextureData handleResourceLocation(String path) {
        String[] parts = path.split(":");
        if (parts.length > 2) {
            Iris.logger.warn("Invalid resource location: {}", path);
        }
        if ("minecraft".equals(parts[0]) && (parts[1].equals("dynamic/lightmap_1") || parts[1].equals("dynamic/light_map_1"))) {
            return new CustomTextureData.LightmapMarker();
        }
        return new CustomTextureData.ResourceData(parts[0], parts[1]);
    }

    private String normalizePath(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private TextureFilteringData resolveFilteringData(Path root, String path, TextureDefinition def) {
        boolean blur = def instanceof TextureDefinition.RawDefinition || this.isSkyTexture(def);
        boolean clamp = def instanceof TextureDefinition.RawDefinition || this.isSkyTexture(def);
        Path metaPath = root.resolve(path + ".mcmeta");
        if (Files.exists(metaPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(metaPath);){
                JsonObject meta = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonObject textureMeta = meta.getAsJsonObject("texture");
                if (textureMeta != null) {
                    blur = textureMeta.has("blur") ? textureMeta.get("blur").getAsBoolean() : blur;
                    clamp = textureMeta.has("clamp") ? textureMeta.get("clamp").getAsBoolean() : clamp;
                }
            }
            catch (Exception e) {
                Iris.logger.error("Failed to read texture metadata: {}", metaPath, e);
            }
        }
        return new TextureFilteringData(blur, clamp);
    }

    private boolean isSkyTexture(TextureDefinition definition) {
        return definition.getName().contains("sky") || definition.getName().contains("cloud");
    }

    private CustomTextureData createTextureData(TextureDefinition definition, TextureFilteringData filtering, byte[] data) {
        if (definition instanceof TextureDefinition.PNGDefinition) {
            return new CustomTextureData.PngData(filtering, data);
        }
        if (definition instanceof TextureDefinition.RawDefinition) {
            TextureDefinition.RawDefinition raw = (TextureDefinition.RawDefinition)definition;
            return switch (raw.getTarget()) {
                default -> throw new MatchException(null, null);
                case TextureType.TEXTURE_1D -> new CustomTextureData.RawData1D(data, filtering, raw.getInternalFormat(), raw.getFormat(), raw.getPixelType(), raw.getSizeX());
                case TextureType.TEXTURE_2D -> new CustomTextureData.RawData2D(data, filtering, raw.getInternalFormat(), raw.getFormat(), raw.getPixelType(), raw.getSizeX(), raw.getSizeY());
                case TextureType.TEXTURE_3D -> new CustomTextureData.RawData3D(data, filtering, raw.getInternalFormat(), raw.getFormat(), raw.getPixelType(), raw.getSizeX(), raw.getSizeY(), raw.getSizeZ());
                case TextureType.TEXTURE_RECTANGLE -> new CustomTextureData.RawDataRect(data, filtering, raw.getInternalFormat(), raw.getFormat(), raw.getPixelType(), raw.getSizeX(), raw.getSizeY());
            };
        }
        throw new IllegalArgumentException("Unsupported texture type: " + definition.getClass().getSimpleName());
    }

    private CustomTextureData createFallbackTexture(TextureDefinition def) {
        int size = 64;
        if (def instanceof TextureDefinition.RawDefinition) {
            TextureDefinition.RawDefinition raw = (TextureDefinition.RawDefinition)def;
            size = Math.max(raw.getSizeX(), Math.max(raw.getSizeY(), raw.getSizeZ()));
        }
        return new CustomTextureData.PngData(new TextureFilteringData(false, false), new byte[0]);
    }

    public ProgramSet getProgramSet(NamespacedId dimension) {
        ProgramSetInterface override = this.overrides.computeIfAbsent(dimension, dim -> {
            String name = this.dimensionMap.getOrDefault(dim, "");
            return this.dimensionIds.contains(name) ? new ProgramSet(AbsolutePackPath.fromAbsolutePath("/" + name), this.sourceProvider, this.shaderProperties, this) : ProgramSetInterface.Empty.INSTANCE;
        });
        return override instanceof ProgramSet ? (ProgramSet)override : this.base;
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public List<ImageInformation> getIrisCustomImages() {
        return this.irisCustomImages;
    }

    public Object2ObjectMap<String, CustomTextureData> getIrisCustomTextureDataMap() {
        return this.irisCustomTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    public boolean hasFeature(FeatureFlags feature) {
        return this.activeFeatures.contains((Object)feature);
    }

    private static Optional<Properties> loadProperties(Path shaderPath, Iterable<StringPair> environmentDefines) {
        return ShaderPack.loadPropertiesAsString(shaderPath, DIMENSION_CONFIG_NAME, environmentDefines).map(content -> {
            OrderBackedProperties props = new OrderBackedProperties();
            try {
                props.load(new StringReader((String)content));
            }
            catch (IOException e) {
                Iris.logger.error("Error loading properties", e);
            }
            return props;
        });
    }

    private static Optional<String> loadPropertiesAsString(Path shaderPath, String name, Iterable<StringPair> environmentDefines) {
        try {
            String fileContents = Files.readString(shaderPath.resolve(name), StandardCharsets.ISO_8859_1);
            return Optional.of((String)PREPROCESS_CACHE.getUnchecked((Object)new PreprocessKey(fileContents, (ImmutableList<StringPair>)ImmutableList.copyOf(environmentDefines))));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            Iris.logger.error("IO error reading properties", e);
            return Optional.empty();
        }
    }

    private static Map<NamespacedId, String> parseDimensionMap(Properties properties) {
        fileName = DIMENSION_CONFIG_NAME;
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> ShaderPack.lambda$parseDimensionMap$31((Map)map, arg_0, arg_1)));
        return map;
    }

    private List<String> parseDimensionIds(Properties properties) {
        return properties.stringPropertyNames().stream().filter(key -> key.startsWith("dimension.")).map(key -> key.substring("dimension.".length())).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$parseDimensionMap$31(Map map, Object k, Object v) {
        String key = (String)k;
        if (key.startsWith("dimension.")) {
            String value = (String)v;
            Arrays.stream(value.split("\\s+")).forEach(part -> {
                NamespacedId id = part.equals("*") ? new NamespacedId("*", "*") : new NamespacedId((String)part);
                map.put(id, key.substring("dimension.".length()));
            });
        }
    }

    private /* synthetic */ void lambda$new$21(Object2ObjectMap futures, TextureStage stage) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        futures.forEach((arg_0, arg_1) -> ShaderPack.lambda$new$20((Object2ObjectMap)result, arg_0, arg_1));
        this.customTextureDataMap.put(stage, (Object2ObjectMap<String, CustomTextureData>)result);
    }

    private static /* synthetic */ void lambda$new$20(Object2ObjectMap result, String key, CompletableFuture value) {
        result.put((Object)key, (Object)((CustomTextureData)value.join()));
    }

    private /* synthetic */ void lambda$new$19(Path root, Object2ObjectMap futures, String name, TextureDefinition def) {
        CompletableFuture<CustomTextureData> future = ((CompletableFuture)this.readTextureAsync(root, def).exceptionally(ex -> {
            Iris.logger.error("Failed to load texture {}: {}", name, def.getName(), ex);
            return this.createFallbackTexture(def);
        })).completeOnTimeout(this.createFallbackTexture(def), 2L, TimeUnit.SECONDS);
        futures.put((Object)name, future);
    }

    private static /* synthetic */ String lambda$new$14(List disabledPrograms, IncludeProcessor includeProcessor, Iterable finalEnvironmentDefines1, AbsolutePackPath path) {
        String pathString;
        String programString = pathString.substring((pathString = path.getPathString()).startsWith("/") ? 1 : 0, pathString.lastIndexOf(46));
        if (disabledPrograms.contains(programString)) {
            return null;
        }
        ImmutableList<String> lines = includeProcessor.getIncludedFile(path);
        if (lines == null) {
            return null;
        }
        return JcppProcessor.glslPreprocessSource(String.join((CharSequence)"\n", lines), finalEnvironmentDefines1);
    }

    static {
        PREPROCESS_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<PreprocessKey, String>(){

            @NotNull
            public String load(@NotNull PreprocessKey key) {
                return PropertiesPreprocessor.preprocessSource(key.content, key.defines);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            TEXTURE_LOAD_EXECUTOR.shutdown();
            try {
                if (!TEXTURE_LOAD_EXECUTOR.awaitTermination(3L, TimeUnit.SECONDS)) {
                    TEXTURE_LOAD_EXECUTOR.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }

    private record PreprocessKey(@NotNull String content, @NotNull ImmutableList<StringPair> defines) {
        private static final Map<String, String> CONTENT_CACHE = Collections.synchronizedMap(new WeakHashMap());

        public PreprocessKey(@NotNull String content, @NotNull ImmutableList<StringPair> defines) {
            this.content = content = CONTENT_CACHE.computeIfAbsent(content, k -> k);
            this.defines = defines;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            ImmutableList<StringPair> content1;
            ImmutableList<StringPair> immutableList;
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreprocessKey)) return false;
            PreprocessKey preprocessKey = (PreprocessKey)o;
            try {
                content1 = immutableList = preprocessKey.content();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ImmutableList<StringPair> defines1 = immutableList = preprocessKey.defines();
            if (!this.content.equals(content1)) return false;
            if (!this.defines.equals(defines1)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + this.defines.hashCode();
            return result;
        }
    }
}

