/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin.texture.pbr;

import net.irisshaders.iris.pbr.texture.PBRType;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DirectoryLister.class})
public class MixinDirectoryLister {
    @Shadow
    @Final
    private String sourcePath;
    @Shadow
    @Final
    private String idPrefix;

    @Overwrite
    public void run(ResourceManager resourceManager, SpriteSource.Output output) {
        FileToIdConverter fileToIdConverter = new FileToIdConverter("textures/" + this.sourcePath, ".png");
        fileToIdConverter.listMatchingResources(resourceManager).forEach((location, resource) -> {
            ResourceLocation baseLocation;
            String basePath = PBRType.removeSuffix(location.getPath());
            if (basePath != null && resourceManager.getResource(baseLocation = location.withPath(basePath)).isPresent()) {
                return;
            }
            ResourceLocation resourceLocation = fileToIdConverter.fileToId(location).withPrefix(this.idPrefix);
            output.add(resourceLocation, resource);
        });
    }
}

