/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.embeddium.impl.oculus.vertices.terrain;

import net.irisshaders.iris.compat.embeddium.impl.BlockContextHolder;
import net.irisshaders.iris.compat.embeddium.impl.VertexEncoderInterface;
import net.irisshaders.iris.compat.embeddium.impl.oculus.vertices.terrain.QuadViewTerrain;
import net.irisshaders.iris.compat.embeddium.impl.oculus.vertices.terrain.XHFPModelVertexType;
import net.irisshaders.iris.vertices.ExtendedDataHelper;
import net.irisshaders.iris.vertices.NormI8;
import net.irisshaders.iris.vertices.NormalHelper;
import net.minecraft.util.Mth;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class XHFPTerrainVertex
implements ChunkVertexEncoder,
VertexEncoderInterface {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;
    private boolean flipUpcomingNormal;

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }

    public void flipUpcomingQuadNormal() {
        this.flipUpcomingNormal = true;
    }

    public long write(long ptr, Material material, ChunkVertexEncoder.Vertex vertex, int chunkId) {
        this.uSum += vertex.u;
        this.vSum += vertex.v;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)ptr, (short)XHFPModelVertexType.encodePosition(vertex.x));
        MemoryUtil.memPutShort((long)(ptr + 2L), (short)XHFPModelVertexType.encodePosition(vertex.y));
        MemoryUtil.memPutShort((long)(ptr + 4L), (short)XHFPModelVertexType.encodePosition(vertex.z));
        MemoryUtil.memPutByte((long)(ptr + 6L), (byte)((byte)material.bits()));
        MemoryUtil.memPutByte((long)(ptr + 7L), (byte)((byte)chunkId));
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)vertex.color);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)XHFPModelVertexType.encodeTexture(vertex.u, vertex.v));
        MemoryUtil.memPutInt((long)(ptr + 16L), (int)vertex.light);
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)this.packBlockId(this.contextHolder));
        MemoryUtil.memPutInt((long)(ptr + 36L), (int)(this.contextHolder.ignoreMidBlock() ? 0 : ExtendedDataHelper.computeMidBlock(vertex.x, vertex.y, vertex.z, this.contextHolder.getLocalPosX(), this.contextHolder.getLocalPosY(), this.contextHolder.getLocalPosZ())));
        MemoryUtil.memPutByte((long)(ptr + 39L), (byte)this.contextHolder.getBlockEmission());
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            int midUV = XHFPModelVertexType.encodeTexture(this.uSum, this.vSum);
            MemoryUtil.memPutInt((long)(ptr + 20L), (int)midUV);
            MemoryUtil.memPutInt((long)(ptr + 20L - 40L), (int)midUV);
            MemoryUtil.memPutInt((long)(ptr + 20L - 80L), (int)midUV);
            MemoryUtil.memPutInt((long)(ptr + 20L - 120L), (int)midUV);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(ptr, 40);
            if (this.flipUpcomingNormal) {
                NormalHelper.computeFaceNormalFlipped(this.normal, this.quad);
                this.flipUpcomingNormal = false;
            } else {
                NormalHelper.computeFaceNormal(this.normal, this.quad);
            }
            int packedNormal = NormI8.pack(this.normal);
            MemoryUtil.memPutInt((long)(ptr + 28L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 28L - 40L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 28L - 80L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 28L - 120L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(ptr + 24L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 24L - 40L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 24L - 80L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 24L - 120L), (int)tangent);
        }
        return ptr + 40L;
    }

    private static int packPositionHi(int x, int y, int z) {
        return (x >>> 10 & 0x3FF) << 0 | (y >>> 10 & 0x3FF) << 10 | (z >>> 10 & 0x3FF) << 20;
    }

    private static int packPositionLo(int x, int y, int z) {
        return (x & 0x3FF) << 0 | (y & 0x3FF) << 10 | (z & 0x3FF) << 20;
    }

    private static int quantizePosition(float position) {
        return (int)(XHFPTerrainVertex.normalizePosition(position) * 1048576.0f) & 0xFFFFF;
    }

    private static float normalizePosition(float v) {
        return (8.0f + v) / 32.0f;
    }

    private static int packTexture(int u, int v) {
        return (u & 0xFFFF) << 0 | (v & 0xFFFF) << 16;
    }

    private static int encodeTexture(float center, float x) {
        int bias = x < center ? 1 : -1;
        int quantized = XHFPTerrainVertex.floorInt(x * 32768.0f) + bias & Short.MAX_VALUE;
        if (bias < 0) {
            quantized = -quantized;
        }
        return quantized;
    }

    private static int encodeLight(int light) {
        int sky = Mth.clamp((int)(light >>> 16 & 0xFF), (int)8, (int)248);
        int block = Mth.clamp((int)(light >>> 0 & 0xFF), (int)8, (int)248);
        return block << 0 | sky << 8;
    }

    private static int packLightAndData(int light, int material, int section) {
        return (light & 0xFFFF) << 0 | (material & 0xFF) << 16 | (section & 0xFF) << 24;
    }

    private static int floorInt(float x) {
        return (int)Math.floor(x);
    }

    private int packBlockId(BlockContextHolder contextHolder) {
        return contextHolder.getBlockId() + 1 << 1 | contextHolder.getRenderType() & 1;
    }
}

