/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.client.icon.KubeIcon;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.codec.KubeJSStreamCodecs;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record NotificationToastData(Duration duration, Component text, Optional<KubeIcon> icon, int iconSize, Optional<KubeColor> outlineColor, Optional<KubeColor> borderColor, Optional<KubeColor> backgroundColor, boolean textShadow) {
    public static final Duration DEFAULT_DURATION = Duration.ofSeconds(5L);
    public static final KubeColor DEFAULT_OUTLINE_COLOR = SimpleColor.BLACK;
    public static final KubeColor DEFAULT_BORDER_COLOR = new SimpleColor(4663636);
    public static final KubeColor DEFAULT_BACKGROUND_COLOR = new SimpleColor(2364213);
    public static final MapCodec<NotificationToastData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)KubeJSCodecs.DURATION.optionalFieldOf("duration", (Object)DEFAULT_DURATION).forGetter(NotificationToastData::duration), (App)ComponentSerialization.CODEC.optionalFieldOf("text", (Object)Component.empty()).forGetter(NotificationToastData::text), (App)KubeIcon.CODEC.optionalFieldOf("icon").forGetter(NotificationToastData::icon), (App)Codec.INT.optionalFieldOf("icon_size", (Object)16).forGetter(NotificationToastData::iconSize), (App)KubeColor.CODEC.optionalFieldOf("outline_color").forGetter(NotificationToastData::outlineColor), (App)KubeColor.CODEC.optionalFieldOf("border_color").forGetter(NotificationToastData::borderColor), (App)KubeColor.CODEC.optionalFieldOf("background_color").forGetter(NotificationToastData::backgroundColor), (App)Codec.BOOL.optionalFieldOf("text_shadow", (Object)false).forGetter(NotificationToastData::textShadow)).apply((Applicative)instance, NotificationToastData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NotificationToastData> STREAM_CODEC = KubeJSStreamCodecs.composite(KubeJSStreamCodecs.DURATION, NotificationToastData::duration, ComponentSerialization.STREAM_CODEC, NotificationToastData::text, KubeIcon.OPTIONAL_STREAM_CODEC, NotificationToastData::icon, ByteBufCodecs.VAR_INT, NotificationToastData::iconSize, KubeColor.OPTIONAL_STREAM_CODEC, NotificationToastData::outlineColor, KubeColor.OPTIONAL_STREAM_CODEC, NotificationToastData::borderColor, KubeColor.OPTIONAL_STREAM_CODEC, NotificationToastData::backgroundColor, ByteBufCodecs.BOOL, NotificationToastData::textShadow, NotificationToastData::new);

    public static NotificationToastData ofText(Component text) {
        return new NotificationToastData(DEFAULT_DURATION, text, Optional.empty(), 16, Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    public static NotificationToastData ofTitle(Component title, @Nullable Component text) {
        return text == null ? NotificationToastData.ofText(title) : NotificationToastData.ofText((Component)Component.empty().append(title).append("\n").append(text));
    }
}

