/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Optional;

public record EitherRecipeComponent<H, L>(RecipeComponent<H> left, RecipeComponent<L> right, Codec<Either<H, L>> codec, TypeInfo typeInfo) implements RecipeComponent<Either<H, L>>
{
    public static final RecipeComponentType<?> TYPE = RecipeComponentType.dynamic(KubeJS.id("either"), (type, ctx) -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)ctx.recipeComponentCodec().fieldOf("left").forGetter(EitherRecipeComponent::left), (App)ctx.recipeComponentCodec().fieldOf("right").forGetter(EitherRecipeComponent::right)).apply((Applicative)instance, EitherRecipeComponent::new)));

    public EitherRecipeComponent(RecipeComponent<H> left, RecipeComponent<L> right) {
        this(left, right, Codec.either(left.codec(), right.codec()), left.typeInfo().or(right.typeInfo()));
    }

    @Override
    public RecipeComponentType<?> type() {
        return TYPE;
    }

    @Override
    public Either<H, L> wrap(RecipeScriptContext cx, Object from) {
        Object value;
        Object value2;
        if (this.left.hasPriority(cx, from)) {
            value2 = this.left.wrap(cx, from);
            if (this.left.allowEmpty() || !this.left.isEmpty(value2)) {
                return Either.left(value2);
            }
        }
        if (this.right.hasPriority(cx, from)) {
            value2 = this.right.wrap(cx, from);
            if (this.right.allowEmpty() || !this.right.isEmpty(value2)) {
                return Either.right(value2);
            }
        }
        Exception ex1 = null;
        try {
            value = this.left.wrap(cx, from);
            if (this.left.allowEmpty() || !this.left.isEmpty(value)) {
                this.left.validate(cx, value);
                return Either.left(value);
            }
        }
        catch (Exception ex) {
            ex1 = ex;
        }
        try {
            value = this.right.wrap(cx, from);
            if (this.right.allowEmpty() || !this.right.isEmpty(value)) {
                return Either.right(value);
            }
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.warn("Failed to read %s (left: %s)!".formatted(from, this.left), ex1);
            ConsoleJS.SERVER.warn("Failed to read %s (right: %s)!".formatted(from, this.right), ex);
        }
        throw new KubeRuntimeException("Failed to read %s as either %s or %s!".formatted(from, this.left, this.right)).source(cx.recipe().sourceLine);
    }

    @Override
    public boolean matches(RecipeMatchContext cx, Either<H, L> value, ReplacementMatchInfo match) {
        Optional l = value.left();
        return l.isPresent() ? this.left.matches(cx, l.get(), match) : this.right.matches(cx, value.right().get(), match);
    }

    @Override
    public Either<H, L> replace(RecipeScriptContext cx, Either<H, L> original, ReplacementMatchInfo match, Object with) {
        Optional l = original.left();
        if (l.isPresent()) {
            H r = this.left.replace(cx, l.get(), match, with);
            return r == l.get() ? original : Either.left(r);
        }
        L r = this.right.replace(cx, original.right().get(), match, with);
        return r == original.right().get() ? original : Either.right(r);
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Either<H, L> value) {
        Optional l = value.left();
        if (l.isPresent()) {
            this.left.buildUniqueId(builder, l.get());
        } else {
            this.right.buildUniqueId(builder, value.right().get());
        }
    }

    @Override
    public void validate(RecipeValidationContext ctx, Either<H, L> value) {
        ctx.errors().push(this);
        Optional l = value.left();
        if (l.isPresent()) {
            ctx.errors().setKey("left");
            this.left.validate(ctx, l.get());
        } else {
            ctx.errors().setKey("right");
            this.right.validate(ctx, value.right().get());
        }
        ctx.errors().pop();
    }

    @Override
    public String toString() {
        return "either<" + String.valueOf(this.left) + ", " + String.valueOf(this.right) + ">";
    }

    @Override
    public String toString(OpsContainer ops, Either<H, L> value) {
        Optional l = value.left();
        if (l.isPresent()) {
            return this.left.toString(ops, l.get());
        }
        return this.right.toString(ops, value.right().get());
    }

    @Override
    public List<?> spread(Either<H, L> value) {
        Optional l = value.left();
        if (l.isPresent()) {
            return this.left.spread(l.get());
        }
        return this.right.spread(value.right().get());
    }
}

