/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.latvian.mods.kubejs.core.BlockProviderKJS;
import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.ExplosionProperties;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BlockWrapper;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface LevelBlock
extends BlockProviderKJS {
    public Level getLevel();

    public BlockPos getPos();

    @Override
    default public Block kjs$getBlock() {
        return this.getBlockState().getBlock();
    }

    @HideFromJS
    default public LevelBlock cache(BlockState state) {
        return this;
    }

    @HideFromJS
    default public LevelBlock cache(BlockEntity entity) {
        return this;
    }

    default public ResourceKey<Level> getDimensionKey() {
        return this.getLevel().dimension();
    }

    default public ResourceLocation getDimension() {
        return this.getDimensionKey().location();
    }

    default public int getX() {
        return this.getPos().getX();
    }

    default public int getY() {
        return this.getPos().getY();
    }

    default public int getZ() {
        return this.getPos().getZ();
    }

    default public double getCenterX() {
        return (double)this.getX() + 0.5;
    }

    default public double getCenterY() {
        return (double)this.getY() + 0.5;
    }

    default public double getCenterZ() {
        return (double)this.getZ() + 0.5;
    }

    default public LevelBlock offset(Direction f, int d) {
        return this.getLevel().kjs$getBlock(this.getPos().relative(f, d));
    }

    default public LevelBlock offset(Direction f) {
        return this.offset(f, 1);
    }

    default public LevelBlock offset(int x, int y, int z) {
        return this.getLevel().kjs$getBlock(this.getPos().offset(x, y, z));
    }

    default public LevelBlock getDown() {
        return this.offset(Direction.DOWN);
    }

    default public LevelBlock getUp() {
        return this.offset(Direction.UP);
    }

    default public LevelBlock getNorth() {
        return this.offset(Direction.NORTH);
    }

    default public LevelBlock getSouth() {
        return this.offset(Direction.SOUTH);
    }

    default public LevelBlock getWest() {
        return this.offset(Direction.WEST);
    }

    default public LevelBlock getEast() {
        return this.offset(Direction.EAST);
    }

    default public BlockState getBlockState() {
        return this.getLevel().getBlockState(this.getPos());
    }

    default public void setBlockState(BlockState state, int flags) {
        this.getLevel().setBlock(this.getPos(), state, flags);
    }

    default public void setBlockState(BlockState state) {
        this.setBlockState(state, 3);
    }

    default public void set(Block block, Map<?, ?> properties, int flags) {
        BlockState state = block.defaultBlockState();
        if (!properties.isEmpty() && state.getBlock() != Blocks.AIR) {
            state = BlockWrapper.withProperties(state, properties);
            HashMap<String, Property> pmap = new HashMap<String, Property>();
            for (Property property : state.getProperties()) {
                pmap.put(property.getName(), property);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (BlockState)state.setValue(property, (Comparable)Cast.to(property.getValue(String.valueOf(entry.getValue())).orElseThrow()));
            }
        }
        this.setBlockState(state, flags);
    }

    default public void set(Block block, Map<?, ?> properties) {
        this.set(block, properties, 3);
    }

    default public void set(Block block) {
        this.set(block, Collections.emptyMap());
    }

    default public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        BlockState state = this.getBlockState();
        for (Property property : state.getProperties()) {
            map.put(property.getName(), property.getName(state.getValue(property)));
        }
        return map;
    }

    @Nullable
    default public BlockEntity getEntity() {
        return this.getLevel().getBlockEntity(this.getPos());
    }

    default public String getEntityId() {
        BlockEntity entity = this.getEntity();
        return entity == null ? "minecraft:air" : BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)entity.getType()).toString();
    }

    @Nullable
    default public CompoundTag getEntityData() {
        BlockEntity entity = this.getEntity();
        if (entity != null) {
            return entity.saveWithoutMetadata((HolderLookup.Provider)this.getLevel().registryAccess());
        }
        return null;
    }

    default public void setEntityData(@Nullable CompoundTag tag) {
        BlockEntity entity;
        if (tag != null && (entity = this.getEntity()) != null) {
            entity.loadWithComponents(tag, (HolderLookup.Provider)this.getLevel().registryAccess());
        }
    }

    default public void mergeEntityData(@Nullable CompoundTag tag) {
        CompoundTag t = this.getEntityData();
        if (t == null) {
            this.setEntityData(tag);
        } else if (tag != null && !tag.isEmpty()) {
            for (String s : tag.getAllKeys()) {
                t.put(s, tag.get(s));
            }
        }
        this.setEntityData(t);
    }

    default public int getLight() {
        return this.getLevel().getMaxLocalRawBrightness(this.getPos());
    }

    default public int getSkyLight() {
        return this.getLevel().getBrightness(LightLayer.SKY, this.getPos()) - this.getLevel().getSkyDarken();
    }

    default public int getBlockLight() {
        return this.getLevel().getBrightness(LightLayer.BLOCK, this.getPos());
    }

    default public boolean getCanSeeSky() {
        return this.getLevel().canSeeSky(this.getPos());
    }

    default public boolean canSeeSkyFromBelowWater() {
        return this.getLevel().canSeeSkyFromBelowWater(this.getPos());
    }

    default public Explosion explode(ExplosionProperties properties) {
        return this.getLevel().kjs$explode((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, properties);
    }

    @Nullable
    default public Entity createEntity(EntityType<?> type) {
        Entity entity = this.getLevel().kjs$createEntity(type);
        if (entity != null) {
            entity.kjs$setPosition(this);
        }
        return entity;
    }

    default public void spawnLightning(boolean effectOnly, @Nullable ServerPlayer player) {
        this.getLevel().kjs$spawnLightning(this.getCenterX(), this.getCenterY(), this.getCenterZ(), effectOnly, player);
    }

    default public void spawnLightning(boolean effectOnly) {
        this.spawnLightning(effectOnly, null);
    }

    default public void spawnLightning() {
        this.spawnLightning(false);
    }

    default public void spawnFireworks(Fireworks fireworks, int lifetime) {
        this.getLevel().kjs$spawnFireworks(this.getCenterX(), this.getCenterY(), this.getCenterZ(), fireworks, lifetime);
    }

    @Nullable
    default public InventoryKJS getInventory() {
        return this.getInventory(Direction.UP);
    }

    @Nullable
    default public InventoryKJS getInventory(Direction facing) {
        BlockEntity entity = this.getEntity();
        if (entity != null) {
            IItemHandler c = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.getPos(), this.getBlockState(), this.getEntity(), (Object)facing);
            if (c instanceof InventoryKJS) {
                InventoryKJS inv = (InventoryKJS)c;
                return inv;
            }
            if (entity instanceof InventoryKJS) {
                InventoryKJS inv = (InventoryKJS)entity;
                return inv;
            }
        }
        return null;
    }

    default public ItemStack getItem() {
        BlockState state = this.getBlockState();
        return state.getBlock().getCloneItemStack((LevelReader)this.getLevel(), this.getPos(), state);
    }

    default public List<ItemStack> getDrops() {
        return this.getDrops(null, ItemStack.EMPTY);
    }

    default public List<ItemStack> getDrops(@Nullable Entity entity, ItemStack heldItem) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            return Block.getDrops((BlockState)this.getBlockState(), (ServerLevel)s, (BlockPos)this.getPos(), (BlockEntity)this.getEntity(), (Entity)entity, (ItemStack)heldItem);
        }
        return List.of();
    }

    default public void popItem(ItemStack item) {
        Block.popResource((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)item);
    }

    default public void popItemFromFace(ItemStack item, Direction dir) {
        Block.popResourceFromFace((Level)this.getLevel(), (BlockPos)this.getPos(), (Direction)dir, (ItemStack)item);
    }

    default public EntityArrayList getPlayersInRadius(double radius) {
        EntityArrayList list = new EntityArrayList(1);
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        double cz = this.getCenterZ();
        for (Entity entity : this.getLevel().getEntities((Entity)null, new AABB(cx - 0.5 - radius, cy - 0.5 - radius, cz - 0.5 - radius, cx + 0.5 + radius, cy + 0.5 + radius, cz + 0.5 + radius), EntityArrayList.ALWAYS_TRUE_PREDICATE)) {
            Player p;
            if (!(entity.distanceToSqr(cx, cy, cz) <= radius * radius) || !(entity instanceof Player) || (p = (Player)entity).isFakePlayer()) continue;
            list.add(p);
        }
        return list;
    }

    default public EntityArrayList getPlayersInRadius() {
        return this.getPlayersInRadius(8.0);
    }

    default public ResourceLocation getBiomeId() {
        ResourceKey k = this.getLevel().getBiome(this.getPos()).getKey();
        return k == null ? Biomes.PLAINS.location() : k.location();
    }

    default public String toBlockStateString() {
        String id = this.kjs$getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id;
        }
        StringBuilder builder = new StringBuilder(id);
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }
}

