/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.vectorization;

import guideme.internal.shaded.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsScorer;
import guideme.internal.shaded.lucene.codecs.lucene95.HasIndexSlice;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorer;
import guideme.internal.shaded.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorerSupplier;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import guideme.internal.shaded.lucene.util.quantization.QuantizedByteVectorValues;
import java.io.IOException;
import java.util.Optional;

public class Lucene99MemorySegmentFlatVectorsScorer
implements FlatVectorsScorer {
    public static final Lucene99MemorySegmentFlatVectorsScorer INSTANCE = new Lucene99MemorySegmentFlatVectorsScorer(DefaultFlatVectorScorer.INSTANCE);
    private final FlatVectorsScorer delegate;

    private Lucene99MemorySegmentFlatVectorsScorer(FlatVectorsScorer delegate) {
        this.delegate = delegate;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues) throws IOException {
        Optional<RandomVectorScorerSupplier> scorer;
        HasIndexSlice byteVectorValues;
        ByteVectorValues bvv;
        assert (!(vectorValues instanceof QuantizedByteVectorValues));
        if (vectorValues instanceof ByteVectorValues && (bvv = (ByteVectorValues)vectorValues) instanceof HasIndexSlice && (byteVectorValues = (HasIndexSlice)((Object)bvv)).getSlice() != null && (scorer = Lucene99MemorySegmentByteVectorScorerSupplier.create(similarityType, byteVectorValues.getSlice(), vectorValues)).isPresent()) {
            return scorer.get();
        }
        return this.delegate.getRandomVectorScorerSupplier(similarityType, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues, float[] target) throws IOException {
        return this.delegate.getRandomVectorScorer(similarityType, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues, byte[] queryVector) throws IOException {
        Optional<Lucene99MemorySegmentByteVectorScorer> scorer;
        HasIndexSlice byteVectorValues;
        ByteVectorValues bvv;
        Lucene99MemorySegmentFlatVectorsScorer.checkDimensions(queryVector.length, vectorValues.dimension());
        assert (!(vectorValues instanceof QuantizedByteVectorValues));
        if (vectorValues instanceof ByteVectorValues && (bvv = (ByteVectorValues)vectorValues) instanceof HasIndexSlice && (byteVectorValues = (HasIndexSlice)((Object)bvv)).getSlice() != null && (scorer = Lucene99MemorySegmentByteVectorScorer.create(similarityType, byteVectorValues.getSlice(), vectorValues, queryVector)).isPresent()) {
            return scorer.get();
        }
        return this.delegate.getRandomVectorScorer(similarityType, vectorValues, queryVector);
    }

    static void checkDimensions(int queryLen, int fieldLen) {
        if (queryLen != fieldLen) {
            throw new IllegalArgumentException("vector query dimension: " + queryLen + " differs from field dimension: " + fieldLen);
        }
    }

    public String toString() {
        return "Lucene99MemorySegmentFlatVectorsScorer()";
    }
}

