/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;

public final class FacetUtils {
    private FacetUtils() {
    }

    public static DocIdSetIterator liveDocsDISI(final DocIdSetIterator it, final Bits liveDocs) {
        return new DocIdSetIterator(){

            @Override
            public int docID() {
                return it.docID();
            }

            private int doNext(int doc) throws IOException {
                assert (doc == it.docID());
                while (doc != Integer.MAX_VALUE && !liveDocs.get(doc)) {
                    doc = it.nextDoc();
                }
                return doc;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.doNext(it.nextDoc());
            }

            @Override
            public int advance(int target) throws IOException {
                return this.doNext(it.advance(target));
            }

            @Override
            public long cost() {
                return it.cost();
            }
        };
    }
}

