/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.AnalyzerWrapper;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.miscellaneous.LimitTokenCountFilter;

public final class LimitTokenCountAnalyzer
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final int maxTokenCount;
    private final boolean consumeAllTokens;

    public LimitTokenCountAnalyzer(Analyzer delegate, int maxTokenCount) {
        this(delegate, maxTokenCount, false);
    }

    public LimitTokenCountAnalyzer(Analyzer delegate, int maxTokenCount, boolean consumeAllTokens) {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        this.maxTokenCount = maxTokenCount;
        this.consumeAllTokens = consumeAllTokens;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new LimitTokenCountFilter(components.getTokenStream(), this.maxTokenCount, this.consumeAllTokens));
    }

    public String toString() {
        return "LimitTokenCountAnalyzer(" + this.delegate.toString() + ", maxTokenCount=" + this.maxTokenCount + ", consumeAllTokens=" + this.consumeAllTokens + ")";
    }
}

