/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import guideme.Guides;
import guideme.GuidesCommon;
import guideme.PageAnchor;
import guideme.internal.command.GuideIdArgument;
import guideme.internal.command.PageAnchorArgument;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public final class GuideCommand {
    private GuideCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = Commands.literal((String)"guideme");
        ((LiteralArgumentBuilder)rootCommand.requires(p -> p.hasPermission(2))).then(Commands.literal((String)"open").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"guide", (ArgumentType)GuideIdArgument.argument()).executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            for (ServerPlayer target : EntityArgument.getPlayers((CommandContext)context, (String)"targets")) {
                GuidesCommon.openGuide((Player)target, guideId);
            }
            return 0;
        })).then(Commands.argument((String)"page", (ArgumentType)PageAnchorArgument.argument()).executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            PageAnchor anchor = PageAnchorArgument.getPageAnchor((CommandContext<CommandSourceStack>)context, "page");
            for (ServerPlayer target : EntityArgument.getPlayers((CommandContext)context, (String)"targets")) {
                GuidesCommon.openGuide((Player)target, guideId, anchor);
            }
            return 0;
        })))));
        ((LiteralArgumentBuilder)rootCommand.requires(p -> p.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"guide", (ArgumentType)GuideIdArgument.argument()).executes(context -> GuideCommand.giveGuide((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), GuideIdArgument.getGuide(context, "guide"))))));
        dispatcher.register(rootCommand);
    }

    private static int giveGuide(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation guideId) {
        ItemStack guideItem = Guides.createGuideItem(guideId);
        for (ServerPlayer target : targets) {
            ItemHandlerHelper.giveItemToPlayer((Player)target, (ItemStack)guideItem.copy());
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, guideItem.getDisplayName(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, guideItem.getDisplayName(), targets.size()}), true);
        }
        return targets.size();
    }
}

