/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones;

import dev.ftb.mods.ftbchunks.api.client.event.MapIconEvent;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones.WaystoneData;
import dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones.WaystoneMapIcon;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class WaystonesCommon {
    private static final Map<ResourceKey<Level>, Map<UUID, WaystoneMapIcon>> WAYSTONES = new HashMap<ResourceKey<Level>, Map<UUID, WaystoneMapIcon>>();
    private static final Map<UUID, ResourceKey<Level>> BY_ID = new HashMap<UUID, ResourceKey<Level>>();

    public static void init() {
        MapIconEvent.MINIMAP.register(WaystonesCommon::mapWidgets);
        MapIconEvent.LARGE_MAP.register(WaystonesCommon::mapWidgets);
        FTBXModCompat.LOGGER.info("[FTB Chunks] Enabled Waystones integration");
    }

    public static void mapWidgets(MapIconEvent event) {
        WAYSTONES.getOrDefault(event.getDimension(), Collections.emptyMap()).values().forEach(arg_0 -> ((MapIconEvent)event).add(arg_0));
    }

    public static void removeWaystone(UUID waystoneId) {
        ResourceKey<Level> dim = BY_ID.get(waystoneId);
        if (dim != null && WAYSTONES.containsKey(dim)) {
            WAYSTONES.get(dim).remove(waystoneId);
            BY_ID.remove(waystoneId);
        }
    }

    public static void updateWaystone(UUID waystoneUid, WaystoneData waystoneData) {
        WAYSTONES.computeIfAbsent(waystoneData.dimension(), k -> new HashMap()).put(waystoneUid, waystoneData.icon());
        BY_ID.put(waystoneUid, waystoneData.dimension());
    }
}

