/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class TeamProperty<T> {
    protected final ResourceLocation id;
    private final Supplier<T> defaultValue;
    private boolean playerEditable;
    private boolean shouldSyncToAll;

    protected TeamProperty(ResourceLocation id, Supplier<T> defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.playerEditable = true;
        this.shouldSyncToAll = false;
    }

    protected TeamProperty(ResourceLocation id, T defaultValue) {
        this(id, () -> defaultValue);
    }

    public abstract TeamPropertyType<T> getType();

    public ResourceLocation getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue.get();
    }

    public boolean isPlayerEditable() {
        return this.playerEditable;
    }

    public TeamProperty<T> notPlayerEditable() {
        this.playerEditable = false;
        return this;
    }

    public boolean shouldSyncToAll() {
        return this.shouldSyncToAll;
    }

    public TeamProperty<T> syncToAll() {
        this.shouldSyncToAll = true;
        return this;
    }

    public String getTranslationKey(String prefix) {
        return prefix + "." + this.id.getNamespace() + "." + this.id.getPath();
    }

    public abstract Optional<T> fromString(String var1);

    public abstract void write(RegistryFriendlyByteBuf var1);

    public String toString(T value) {
        return value.toString();
    }

    public void writeValue(RegistryFriendlyByteBuf buf, T value) {
        buf.writeUtf(this.toString(value), Short.MAX_VALUE);
    }

    public T readValue(RegistryFriendlyByteBuf buf) {
        return this.fromString(buf.readUtf(Short.MAX_VALUE)).orElse(this.getDefaultValue());
    }

    public Tag toNBT(T value) {
        return StringTag.valueOf((String)this.toString(value));
    }

    public Optional<T> fromNBT(Tag tag) {
        return this.fromString(tag.getAsString());
    }

    @Nullable
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<T> value) {
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TeamProperty) {
            return this.id.equals((Object)((TeamProperty)o).id);
        }
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.id.toString();
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createDefaultValue() {
        return new TeamPropertyValue<T>(this, this.getDefaultValue());
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createValueFromNetwork(RegistryFriendlyByteBuf buf) {
        return new TeamPropertyValue<T>(this, this.readValue(buf));
    }

    @Deprecated(forRemoval=true)
    public TeamPropertyValue<T> createValueFromNBT(Tag tag) {
        return new TeamPropertyValue<T>(this, this.fromNBT(tag).orElse(this.getDefaultValue()));
    }
}

