/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IntProperty
extends TeamProperty<Integer> {
    public final int minValue;
    public final int maxValue;

    public IntProperty(ResourceLocation id, Supplier<Integer> def, int min, int max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public IntProperty(ResourceLocation id, Supplier<Integer> def) {
        this(id, def, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntProperty(ResourceLocation id, int def, int min, int max) {
        this(id, () -> def, min, max);
    }

    public IntProperty(ResourceLocation id, int def) {
        this(id, () -> def);
    }

    static IntProperty fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new IntProperty(id, buf.readVarInt(), buf.readVarInt(), buf.readVarInt());
    }

    @Override
    public TeamPropertyType<Integer> getType() {
        return TeamPropertyType.INT;
    }

    @Override
    public Optional<Integer> fromString(String string) {
        try {
            int num = Integer.parseInt(string);
            return Optional.of(Mth.clamp((int)num, (int)this.minValue, (int)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(((Integer)this.getDefaultValue()).intValue());
        buf.writeVarInt(this.minValue);
        buf.writeVarInt(this.maxValue);
    }

    @Override
    public void writeValue(RegistryFriendlyByteBuf buf, Integer value) {
        buf.writeInt(value.intValue());
    }

    @Override
    public Integer readValue(RegistryFriendlyByteBuf buf) {
        return buf.readInt();
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<Integer> value) {
        return config.addInt(this.id.getPath(), value.getValue().intValue(), value::setValue, ((Integer)this.getDefaultValue()).intValue(), this.minValue, this.maxValue);
    }

    @Override
    public Tag toNBT(Integer value) {
        return IntTag.valueOf((int)value);
    }

    @Override
    public Optional<Integer> fromNBT(Tag tag) {
        Optional<Integer> optional;
        if (tag instanceof NumericTag) {
            NumericTag n = (NumericTag)tag;
            optional = Optional.of(Mth.clamp((int)n.getAsInt(), (int)this.minValue, (int)this.maxValue));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

