/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ThemeManager;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class AbstractThreePanelScreen<T extends Panel>
extends BaseScreen {
    public static final Pair<Integer, Integer> NO_INSET = Pair.of((Object)0, (Object)0);
    protected static final int BOTTOM_PANEL_H = 25;
    private static final int SCROLLBAR_WIDTH = 12;
    protected final Panel topPanel = this.createTopPanel();
    protected final T mainPanel = this.createMainPanel();
    protected final Panel bottomPanel = this.createBottomPanel();
    protected final PanelScrollBar scrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, (Panel)this.mainPanel);
    private boolean showBottomPanel = true;
    private boolean showCloseButton = false;
    private boolean showScrollBar = true;

    protected AbstractThreePanelScreen() {
    }

    @Override
    public void addWidgets() {
        this.add(this.topPanel);
        this.add((Widget)this.mainPanel);
        if (this.showScrollBar) {
            this.add(this.scrollBar);
        }
        if (this.showBottomPanel) {
            this.add(this.bottomPanel);
        }
    }

    @Override
    public void alignWidgets() {
        int topPanelHeight = this.getTopPanelHeight();
        this.topPanel.setPosAndSize(0, 0, this.width, topPanelHeight);
        this.topPanel.alignWidgets();
        Pair<Integer, Integer> inset = this.mainPanelInset();
        int bottomPanelHeight = this.showBottomPanel ? this.getBottomPanelHeight() + (Integer)inset.getSecond() : 0;
        ((Widget)this.mainPanel).setPosAndSize((Integer)inset.getFirst(), topPanelHeight + (Integer)inset.getSecond(), this.width - (Integer)inset.getFirst() * 2, this.height - topPanelHeight - (Integer)inset.getSecond() * 2 - bottomPanelHeight);
        ((Panel)this.mainPanel).alignWidgets();
        if (this.showBottomPanel) {
            this.bottomPanel.setPosAndSize(0, this.height - this.getBottomPanelHeight(), this.width, this.getBottomPanelHeight());
            this.bottomPanel.alignWidgets();
        }
        if (this.showScrollBar) {
            this.scrollBar.setPosAndSize(((Widget)this.mainPanel).getPosX() + ((Widget)this.mainPanel).getWidth() - this.getScrollbarWidth(), ((Widget)this.mainPanel).getPosY(), this.getScrollbarWidth(), ((Widget)this.mainPanel).getHeight());
        }
    }

    @Override
    public Theme getTheme() {
        return ThemeManager.INSTANCE.getActiveTheme();
    }

    @Override
    public void tick() {
        super.tick();
        int prevWidth = ((Panel)this.mainPanel).width;
        int newWidth = (this.showScrollBar && this.scrollBar.shouldDraw() ? this.getGui().width - this.getScrollbarWidth() - 2 : this.getGui().width) - (Integer)this.mainPanelInset().getFirst() * 2;
        if (prevWidth != newWidth) {
            ((Widget)this.mainPanel).setWidth(newWidth);
            ((Panel)this.mainPanel).alignWidgets();
        }
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if ((key.is(257) || key.is(335)) && key.modifiers.shift()) {
            this.doAccept();
            return true;
        }
        return false;
    }

    protected abstract void doCancel();

    protected abstract void doAccept();

    protected abstract int getTopPanelHeight();

    protected abstract T createMainPanel();

    protected Pair<Integer, Integer> mainPanelInset() {
        return NO_INSET;
    }

    protected int getBottomPanelHeight() {
        return 25;
    }

    protected int getScrollbarWidth() {
        return 12;
    }

    protected Panel createTopPanel() {
        return new TopPanel();
    }

    protected Panel createBottomPanel() {
        return new BottomPanel();
    }

    public void showBottomPanel(boolean show) {
        this.showBottomPanel = show;
    }

    public void showCloseButton(boolean show) {
        this.showCloseButton = show;
    }

    public boolean shouldShowCloseButton() {
        return this.showCloseButton;
    }

    public void showScrollBar(boolean show) {
        this.showScrollBar = show;
    }

    protected class TopPanel
    extends Panel {
        private final SimpleButton closeButton;

        public TopPanel() {
            super(AbstractThreePanelScreen.this);
            this.closeButton = new SimpleButton((Panel)this, (Component)Component.translatable((String)"gui.close"), Icons.CANCEL, (btn, mb) -> AbstractThreePanelScreen.this.doCancel());
        }

        @Override
        public void addWidgets() {
            if (AbstractThreePanelScreen.this.showCloseButton) {
                this.add(this.closeButton);
            }
        }

        @Override
        public void alignWidgets() {
            if (AbstractThreePanelScreen.this.showCloseButton) {
                this.closeButton.setPosAndSize(this.width - 16, (this.height - 14) / 2, 14, 14);
            }
        }

        @Override
        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
            Color4I.BLACK.withAlpha(80).draw(graphics, x, y + h - 1, w, 1);
        }
    }

    private class BottomPanel
    extends Panel {
        private final Button buttonAccept;
        private final Button buttonCancel;

        public BottomPanel() {
            super(AbstractThreePanelScreen.this);
            this.buttonAccept = SimpleTextButton.accept(this, mb -> AbstractThreePanelScreen.this.doAccept(), TextComponentUtils.hotkeyTooltip("\u21e7 + Enter"));
            this.buttonCancel = SimpleTextButton.cancel(this, mb -> AbstractThreePanelScreen.this.doCancel(), TextComponentUtils.hotkeyTooltip("ESC"));
        }

        @Override
        public void addWidgets() {
            this.add(this.buttonAccept);
            this.add(this.buttonCancel);
        }

        @Override
        public void alignWidgets() {
            this.buttonCancel.setPos(this.width - this.buttonCancel.width - 5, 2);
            this.buttonAccept.setPos(this.buttonCancel.posX - this.buttonAccept.width - 5, 2);
        }

        @Override
        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
            Color4I.GRAY.withAlpha(64).draw(graphics, x, y, w, 1);
        }
    }
}

