/*
 * Decompiled with CFR 0.152.
 */
package net.olafski.fastleafdecay;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.olafski.fastleafdecay.FldConfiguration;
import net.olafski.fastleafdecay.FldScheduler;

@Mod(value="fastleafdecay")
public class FastLeafDecay {
    public static final String MOD_ID = "fastleafdecay";
    static final String MOD_NAME = "FastLeafDecay";
    static final String MOD_VERSION = "@VERSION@";
    static Random random = new Random();
    public static FastLeafDecay INSTANCE;
    public FldConfiguration config;

    public FastLeafDecay(FMLModContainer context) {
        INSTANCE = this;
        FldScheduler instance = FldScheduler.INSTANCE;
        Objects.requireNonNull(instance);
        IEventBus modEventBus = context.getEventBus();
        IEventBus event_BUS = NeoForge.EVENT_BUS;
        modEventBus.addListener(this::preInit);
        modEventBus.register(FldConfiguration.class);
        event_BUS.addListener(this::notifyNeighbors);
        event_BUS.addListener(instance::tick);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)FldConfiguration.spec);
    }

    public void preInit(FMLCommonSetupEvent event) {
    }

    public void notifyNeighbors(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!levelAccessor.isClientSide()) {
            BlockState notifierState = event.getState();
            BlockPos blockPos = event.getPos();
            if (notifierState.isAir()) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState state;
                    BlockPos offPos = blockPos.relative(facing);
                    if (!levelAccessor.isAreaLoaded(offPos, 1) || !(state = levelAccessor.getBlockState(offPos)).is(BlockTags.LEAVES)) continue;
                    int minimum = (Integer)FldConfiguration.minimumDecayTime.get();
                    int jitter = (Integer)FldConfiguration.maximumDecayTime.get() - (Integer)FldConfiguration.minimumDecayTime.get();
                    int delay = minimum + random.nextInt(jitter);
                    FldScheduler.INSTANCE.schedule(levelAccessor, offPos, delay);
                }
            }
        }
    }
}

