/*
 * Decompiled with CFR 0.152.
 */
package com.diamondvein;

import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.dataregistry.DataBlock;
import com.diamondvein.BlockDeposits;
import com.diamondvein.ItemBlockDeposits;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="diamondvein")
public class DiamondVein {
    private static DiamondVein instance;
    private final ModContainer context;
    public static DeferredRegister<Item> ITEMS;
    public static DeferredRegister<Block> BLOCKS;
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private final DataBlock<BlockDeposits.Type, BlockDeposits, ItemBlockDeposits> blockdeposits;

    public DiamondVein(ModContainer modContainer) {
        this.context = modContainer;
        instance = this;
        BLOCKS.register(this.context.getEventBus());
        BLOCK_ENTITIES.register(this.context.getEventBus());
        ITEMS.register(this.context.getEventBus());
        this.context.getEventBus().addListener(this::gatherData);
        this.blockdeposits = new DataBlock(BlockDeposits.Type.class, BlockDeposits.class, ItemBlockDeposits.class, BLOCKS, ITEMS, "diamondvein");
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagsProvider blockTags = new BlockTagsProvider(packOutput, lookupProvider, "diamondvein", existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
    }

    static {
        ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"diamondvein");
        BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"diamondvein");
        BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"diamondvein");
    }
}

