/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.integration;

import com.illusivesoulworks.cherishedworlds.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ViewerIntegration {
    private static final Map<String, Boolean> LOADED = new ConcurrentHashMap<String, Boolean>();
    private static Function<Integer, Pair<Integer, Integer>> activeOverride = null;

    private static boolean isModLoaded(String modId) {
        return LOADED.computeIfAbsent(modId, k -> Services.PLATFORM.isModLoaded(modId));
    }

    public static void register(String modId, Function<Integer, Pair<Integer, Integer>> override) {
        if (activeOverride == null && ViewerIntegration.isModLoaded(modId)) {
            activeOverride = override;
        }
    }

    public static Pair<Integer, Integer> getOverride(int height) {
        if (activeOverride != null) {
            return activeOverride.apply(height);
        }
        return null;
    }
}

