/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;

public final class RegistrationContext {
    private final String namespace;
    private final Map<RegistryReference<ResourceKey<Block>, Block>, Function<Block, Item>> placeableBlocks = new HashMap<RegistryReference<ResourceKey<Block>, Block>, Function<Block, Item>>();
    private static final Map<Item, ResourceKey<DecoratedPotPattern>> INTERNAL_POT_PATTERN_ITEMS = new HashMap<Item, ResourceKey<DecoratedPotPattern>>();
    public static final Map<Item, ResourceKey<DecoratedPotPattern>> POT_PATTERN_ITEMS = Collections.unmodifiableMap(INTERNAL_POT_PATTERN_ITEMS);

    public RegistrationContext(String namespace) {
        this.namespace = namespace;
    }

    public String namespace() {
        return this.namespace;
    }

    public void addPlaceableBlock(RegistryReference<ResourceKey<Block>, Block> block, Function<Block, Item> itemBlock) {
        this.placeableBlocks.put(block, itemBlock);
    }

    public Map<RegistryReference<ResourceKey<Block>, Block>, Function<Block, Item>> getPlaceableBlocks() {
        return Collections.unmodifiableMap(this.placeableBlocks);
    }

    public void addPotPatternItem(Item item, ResourceKey<DecoratedPotPattern> pattern) {
        if (INTERNAL_POT_PATTERN_ITEMS.containsKey(item)) {
            Constants.LOG.warn("Mod {} has changed the pot pattern of {} to {} from {}.", new Object[]{this.namespace(), BuiltInRegistries.ITEM.getKey((Object)item), pattern.location(), INTERNAL_POT_PATTERN_ITEMS.get(item).location()});
        }
        INTERNAL_POT_PATTERN_ITEMS.put(item, pattern);
    }
}

