/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.menu.locator.ItemMenuHostLocator;
import de.mari_023.ae2wtlib.AE2wtlibAdditionalComponents;
import de.mari_023.ae2wtlib.api.AE2wtlibComponents;
import de.mari_023.ae2wtlib.api.registration.WTDefinition;
import de.mari_023.ae2wtlib.api.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.api.terminal.WUTHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wut.WTDefinitions;
import java.util.HashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalHandler {
    public final Player player;
    @Nullable
    private WTMenuHost menuHost;
    @Nullable
    private ItemMenuHostLocator locator;
    @Nullable
    private MagnetHost magnetHost;
    private HashMap<Item, Long> restockAbleItems = new HashMap();
    private boolean restockEnabled = false;

    @ApiStatus.Internal
    public CraftingTerminalHandler(Player player) {
        this.player = player;
    }

    public static CraftingTerminalHandler getCraftingTerminalHandler(Player player) {
        return (CraftingTerminalHandler)player.getData(AE2wtlibAdditionalComponents.CT_HANDLER);
    }

    protected void invalidateCache() {
        this.menuHost = null;
        this.locator = null;
        this.magnetHost = null;
        this.restockAbleItems.clear();
        this.restockEnabled = false;
    }

    public ItemStack getCraftingTerminal() {
        this.getLocator();
        if (this.locator != null) {
            return this.locator.locateItem(this.player);
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    private WTMenuHost getMenuHost() {
        if (this.menuHost != null) {
            if (!this.menuHost.isValid()) {
                this.invalidateCache();
                return this.getMenuHost();
            }
            return this.menuHost;
        }
        this.getLocator();
        this.menuHost = this.locator == null ? null : (WTMenuHost)this.locator.locate(this.player, WTMenuHost.class);
        if (this.menuHost == null) {
            this.invalidateCache();
        }
        return this.menuHost;
    }

    @Nullable
    public ItemMenuHostLocator getLocator() {
        if (this.locator != null && WUTHandler.hasTerminal((ItemStack)this.locator.locateItem(this.player), (WTDefinition)WTDefinitions.CRAFTING)) {
            return this.locator;
        }
        boolean locatorWasNotNull = this.locator != null;
        this.locator = WUTHandler.findTerminal((Player)this.player, (WTDefinition)WTDefinitions.CRAFTING);
        if (this.locator == null) {
            this.invalidateCache();
            if (locatorWasNotNull) {
                return this.getLocator();
            }
        }
        return this.locator;
    }

    @Nullable
    public IGrid getTargetGrid() {
        if (this.getMenuHost() == null) {
            return null;
        }
        IGridNode n = this.getMenuHost().getActionableNode();
        if (n == null) {
            return null;
        }
        return n.getGrid();
    }

    public boolean inRange() {
        if (this.getMenuHost() == null) {
            return false;
        }
        this.getMenuHost().updateConnectedAccessPoint();
        this.getMenuHost().updateLinkStatus();
        return this.getMenuHost().getLinkStatus().connected();
    }

    @Nullable
    public MagnetHost getMagnetHost() {
        if (this.magnetHost == null) {
            if (this.getLocator() == null) {
                this.magnetHost = null;
                return null;
            }
            this.magnetHost = new MagnetHost(this);
        }
        return this.magnetHost;
    }

    public long getAccessibleAmount(ItemStack stack) {
        return (long)stack.getCount() + (this.restockAbleItems.get(stack.getItem()) == null ? 0L : this.restockAbleItems.get(stack.getItem()));
    }

    public boolean isRestockAble(ItemStack stack) {
        return this.restockAbleItems.containsKey(stack.getItem());
    }

    public void setRestockAbleItems(HashMap<Item, Long> items) {
        this.restockAbleItems = items;
    }

    public boolean isRestockEnabled() {
        return this.restockEnabled;
    }

    public void checkTerminal() {
        this.restockEnabled = (Boolean)this.getCraftingTerminal().getOrDefault(AE2wtlibComponents.RESTOCK, (Object)false);
    }
}

