/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.categories;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.handlers.ChargerRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.AbstractCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.DrawableHelper;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.LabelDrawable;

public class ChargerCategory
extends AbstractCategory<RecipeHolder<ChargerRecipe>> {
    public static final RecipeType<RecipeHolder<ChargerRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)AERecipeTypes.CHARGER);
    private final IDrawableStatic unfilledArrow;
    private final IDrawable turnsLabel;

    public ChargerCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)AEBlocks.CHARGER, AEBlocks.CHARGER.stack().getHoverName(), (IDrawable)guiHelper.createBlankDrawable(130, 50));
        this.unfilledArrow = DrawableHelper.getUnfilledArrow(guiHelper);
        int turnCount = 10;
        MutableComponent turnsText = Component.literal((String)(turnCount + " turns or 1600 AE"));
        this.turnsLabel = new LabelDrawable((Component)turnsText).bodyColor().noShadow().alignLeft();
    }

    public RecipeType<RecipeHolder<ChargerRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ChargerRecipe> holder, IFocusGroup focuses) {
        ChargerRecipe recipe = (ChargerRecipe)holder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 31, 8).setStandardSlotBackground().addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 8).setStandardSlotBackground().addItemStack(recipe.getResultItem());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 3, 30).addItemStack(AEBlocks.CRANK.stack());
    }

    public void draw(RecipeHolder<ChargerRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.unfilledArrow.draw(guiGraphics, 52, 8);
        this.turnsLabel.draw(guiGraphics, 20, 35);
    }

    public ResourceLocation getRegistryName(RecipeHolder<ChargerRecipe> holder) {
        return holder.id();
    }
}

