/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import xaero.common.HudMod;
import xaero.common.effect.Effects;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.category.rule.resolver.ObjectCategoryRuleResolver;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.state.RadarList;
import xaero.hud.minimap.radar.state.RadarState;

public class RadarStateUpdater {
    private final EntityRadarCategoryManager categoryManager;
    private final RadarState state;
    private Entity lastRenderEntity;
    private final Map<EntityRadarCategory, RadarList> updateMap;

    public RadarStateUpdater(EntityRadarCategoryManager categoryManager, RadarState state) {
        this.categoryManager = categoryManager;
        this.state = state;
        this.updateMap = new HashMap<EntityRadarCategory, RadarList>();
    }

    public void update(ClientLevel world, Entity renderEntity, Player player) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderEntity;
        }
        List<RadarList> radarLists = this.state.getUpdatableLists();
        EntityRadarCategory rootCategory = this.categoryManager.getRootCategory();
        this.ensureCategories(this.state, rootCategory, radarLists);
        radarLists.forEach(RadarList::clearEntities);
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        if (!HudMod.INSTANCE.getSettings().getEntityRadar() && !this.isWorldMapRadarEnabled()) {
            return;
        }
        if (world == null) {
            return;
        }
        if (renderEntity == null) {
            return;
        }
        if (player == null) {
            return;
        }
        if (Misc.hasEffect(player, Effects.NO_RADAR)) {
            return;
        }
        if (Misc.hasEffect(player, Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        if (!MinimapClientWorldDataHelper.getWorldData((ClientLevel)world).getSyncedRules().allowRadarOnServer) {
            return;
        }
        ObjectCategoryRuleResolver categoryRuleResolver = this.categoryManager.getRuleResolver();
        Iterable worldEntities = world.entitiesForRendering();
        boolean shouldHideInvisible = HudMod.INSTANCE.getSettings().radarHideInvisibleEntities;
        for (Entity entity : worldEntities) {
            int heightLimit;
            double offY;
            EntityRadarCategory entityCategory;
            if (entity == null || shouldHideInvisible && this.isInvisibleTo(entity, player) || (entityCategory = categoryRuleResolver.resolve(rootCategory, entity, player)) == null || !entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAYED).booleanValue() || (offY = renderEntity.getY() - entity.getY()) * offY > (double)((heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue()) * heightLimit)) continue;
            RadarList radarList = this.updateMap.get(entityCategory);
            int entityNumber = entityCategory.getSettingValue(EntityRadarCategorySettings.ENTITY_NUMBER).intValue();
            if (entityNumber != 0 && radarList.size() >= entityNumber) continue;
            radarList.add(entity);
        }
    }

    private void ensureCategories(RadarState state, EntityRadarCategory rootCategory, List<RadarList> radarLists) {
        boolean reversedOrder = ModSettings.keyReverseEntityRadar.isDown();
        if (state.getListsGeneratedForConfig() != rootCategory) {
            this.updateMap.clear();
            radarLists.clear();
            this.traceAddCategories(rootCategory, radarLists);
            Collections.sort(radarLists);
            state.setListsGeneratedForConfig(rootCategory);
            state.setListsReversedOrder(false);
        }
        if (state.getListsReversedOrder() == reversedOrder) {
            return;
        }
        Collections.reverse(radarLists);
        state.setListsReversedOrder(reversedOrder);
    }

    private void traceAddCategories(EntityRadarCategory category, List<RadarList> radarLists) {
        category.getDirectSubCategoryIterator().forEachRemaining(sb -> this.traceAddCategories((EntityRadarCategory)sb, radarLists));
        RadarList radarList = RadarList.Builder.getDefault().build().setCategory(category);
        this.updateMap.put(category, radarList);
        radarLists.add(radarList);
    }

    private boolean isWorldMapRadarEnabled() {
        if (!HudMod.INSTANCE.getSupportMods().worldmap()) {
            return false;
        }
        return HudMod.INSTANCE.getSupportMods().worldmapSupport.worldMapIsRenderingRadar();
    }

    private boolean isInvisibleTo(Entity entity, Player player) {
        return entity.isInvisibleTo(player) || this.shouldHideForSneaking(entity, player);
    }

    private boolean shouldHideForSneaking(Entity e, Player p) {
        if (!e.isShiftKeyDown()) {
            return false;
        }
        PlayerTeam team = e.getTeam();
        return team == null || team != p.getTeam();
    }

    public void setLastRenderViewEntity(Entity lastRenderEntity) {
        this.lastRenderEntity = lastRenderEntity;
    }
}

