/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.Component;
import xaero.map.gui.IXaeroClickableWidget;
import xaero.map.settings.ModOptions;
import xaero.map.settings.Option;

public class XaeroCyclingOption<T>
extends Option {
    private List<T> values;
    private Supplier<T> getter;
    private Consumer<T> setter;
    private Supplier<Component> buttonNameSupplier;

    public XaeroCyclingOption(ModOptions option, List<T> values, Supplier<T> getter, Consumer<T> setter, Supplier<Component> buttonNameSupplier) {
        super(option);
        this.values = values;
        this.getter = getter;
        this.setter = setter;
        this.buttonNameSupplier = buttonNameSupplier;
    }

    @Override
    public AbstractWidget createButton(int x, int y, int width) {
        CycleButton resultButton = CycleButton.builder(v -> this.buttonNameSupplier.get()).withValues(this.values).withInitialValue(this.getter.get()).create(x, y, width, 20, this.getCaption(), (button, value) -> {
            this.setter.accept(value);
            button.setValue(value);
        });
        ((IXaeroClickableWidget)resultButton).setXaero_wm_tooltip(() -> this.option.getTooltip());
        return resultButton;
    }

    public String getSearchText() {
        return this.option.getEnumString() + ": " + this.buttonNameSupplier.get().getString();
    }
}

