/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="storagedrawers")
public class CommonEventBusSubscriber {
    @SubscribeEvent
    public static void playerLeftClick(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockDrawers) {
            BlockHitResult hit;
            BlockDrawers blockDrawers = (BlockDrawers)block;
            Player player = event.getEntity();
            if (player.isCreative() && (hit = WorldUtils.rayTraceEyes(level, player, pos)).getType() == HitResult.Type.BLOCK) {
                blockDrawers.leftAction(state, level, pos, player, hit);
                event.setCanceled(blockDrawers.getFaceSlot(state, hit) >= 0);
            }
        }
    }

    @SubscribeEvent
    public static void itemStackedOn(ItemStackedOnOtherEvent event) {
        if (!(event.getStackedOnItem().getItem() instanceof ItemUpgradeStorage)) {
            return;
        }
        if (!(event.getCarriedItem().getItem() instanceof ItemUpgradeStorage)) {
            return;
        }
        Slot slot = event.getSlot();
        if (slot instanceof SlotUpgrade) {
            SlotUpgrade slot2 = (SlotUpgrade)slot;
            ItemStack stacked = event.getStackedOnItem();
            ItemStack carried = event.getCarriedItem();
            ItemStack slotStack = event.getSlot().getItem();
            if (ItemStack.matches((ItemStack)slotStack, (ItemStack)carried) && !ItemStack.matches((ItemStack)slotStack, (ItemStack)stacked)) {
                carried = event.getStackedOnItem();
                stacked = event.getCarriedItem();
            }
            if (slot2.canSwapStack(carried)) {
                event.getSlot().set(carried);
                event.getCarriedSlotAccess().set(stacked);
                event.setCanceled(true);
            }
        }
    }
}

