/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.util;

import com.anthonyhilyard.prism.util.ConfigHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;

public class MinecraftColors {
    private static final Map<String, Integer> minecraftColorMap;

    public static TextColor getColor(String colorName) {
        colorName = ConfigHelper.formatColorName(colorName);
        TextColor result = null;
        if (minecraftColorMap.containsKey(colorName)) {
            result = TextColor.fromRgb((int)minecraftColorMap.get(colorName));
        }
        return result;
    }

    static {
        HashMap loadedColors = Maps.newHashMap();
        for (ChatFormatting color : ChatFormatting.values()) {
            if (!color.isColor()) continue;
            loadedColors.put(ConfigHelper.formatColorName(color.getName()), color.getColor());
        }
        minecraftColorMap = Map.copyOf(loadedColors);
    }
}

