/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein.noise;

import com.denfop.world.vein.noise.Center;
import com.denfop.world.vein.noise.EDTVoronoi;
import com.denfop.world.vein.noise.Pixel;
import com.denfop.world.vein.noise.Point;
import com.denfop.world.vein.noise.ShellCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.RandomSource;

public class PerlinNoiseViewer {
    private static int maxValue = 4;
    private static final int WIDTH = 128 * maxValue;
    private static final int HEIGHT = 128 * maxValue;

    private static Point decodeToPoint(long encoded) {
        return new Point(PerlinNoiseViewer.getX(encoded), PerlinNoiseViewer.getY(encoded));
    }

    private static int getX(long encoded) {
        return (int)(encoded >> 32);
    }

    private static int getY(long encoded) {
        return (int)encoded;
    }

    private static long encode(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    private static boolean hasNeighborInSet(int x, int y, Set<Long> set) {
        return set.contains(PerlinNoiseViewer.encode(x - 1, y)) || set.contains(PerlinNoiseViewer.encode(x + 1, y)) || set.contains(PerlinNoiseViewer.encode(x, y - 1)) || set.contains(PerlinNoiseViewer.encode(x, y + 1));
    }

    private static boolean hasNeighborInSetNear(int x, int y, Set<Long> set) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                if (dx == 0 && dy == 0 || !set.contains(PerlinNoiseViewer.encode(x + dx, y + dy))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ShellCluster> createClusters(RandomSource random) {
        int maxCenters = 512 * maxValue * maxValue * 2;
        double minDist = 3.0;
        ArrayList<Center> centers = Center.generateCenters(maxCenters, minDist, WIDTH, HEIGHT);
        double maxShellRadius = 8.0;
        double maxShellRadiusSq = maxShellRadius * maxShellRadius;
        LinkedList<ShellCluster> clusters = new LinkedList<ShellCluster>();
        Map<Integer, List<Pixel>> centerPixels = EDTVoronoi.fastAssign(centers, WIDTH, HEIGHT, maxShellRadius, random);
        for (Map.Entry<Integer, List<Pixel>> entry : centerPixels.entrySet()) {
            ArrayList<Pixel> pixels = new ArrayList<Pixel>((Collection)entry.getValue());
            pixels.sort(Comparator.comparingDouble(p -> p.dist));
            ShellCluster cluster = new ShellCluster();
            clusters.add(cluster);
            double percentGray = (double)(random.nextInt(10) + 1) / 10.0;
            double percentLightGray = (double)(random.nextInt(8) + 1) / 10.0;
            double percentLightGray1 = (double)(random.nextInt(5) + 1) / 10.0;
            int count = 0;
            HashSet<Long> blacks = new HashSet<Long>();
            HashSet<Long> grays = new HashSet<Long>();
            HashSet<Long> lightGrays = new HashSet<Long>();
            for (Pixel p2 : pixels) {
                long encoded = PerlinNoiseViewer.encode(p2.x, p2.y);
                if (count == 0) {
                    cluster.blacks.add(new Point(p2.x, p2.y));
                    blacks.add(encoded);
                } else if (count < 25) {
                    if (PerlinNoiseViewer.hasNeighborInSet(p2.x, p2.y, blacks)) {
                        if (random.nextDouble() < percentGray) {
                            cluster.grays.add(new Point(p2.x, p2.y));
                            grays.add(encoded);
                        }
                    } else if (PerlinNoiseViewer.hasNeighborInSet(p2.x, p2.y, grays)) {
                        if (random.nextDouble() < percentLightGray) {
                            cluster.lightGrays.add(new Point(p2.x, p2.y));
                            lightGrays.add(encoded);
                        }
                    } else if (PerlinNoiseViewer.hasNeighborInSet(p2.x, p2.y, blacks) && PerlinNoiseViewer.hasNeighborInSetNear(p2.x, p2.y, grays) && random.nextDouble() < percentLightGray1) {
                        cluster.lightGrays.add(new Point(p2.x, p2.y));
                        lightGrays.add(encoded);
                    }
                }
                ++count;
            }
        }
        return clusters;
    }

    public static ShellCluster createVolcanoClusters(RandomSource random) {
        class Pixel {
            short x;
            short y;
            double dist;

            Pixel(int x, int y, double dist) {
                this.x = (short)x;
                this.y = (short)y;
                this.dist = dist;
            }
        }
        int maxCenters = 1;
        double minDist = 1.0;
        ArrayList<Center> centers = Center.generateCenters(maxCenters, minDist, 24, 24);
        double maxShellRadius = 4.0;
        LinkedList<ShellCluster> clusters = new LinkedList<ShellCluster>();
        HashMap<Integer, List> centerPixels = new HashMap<Integer, List>();
        for (int y = 0; y < 24; ++y) {
            for (int x = 0; x < 24; ++x) {
                double minDistSq = Double.MAX_VALUE;
                int nearestIndex = -1;
                for (int i = 0; i < centers.size(); ++i) {
                    Center c = centers.get(i);
                    double dx = (double)x - c.x;
                    double dy = (double)y - c.y;
                    double distSq = dx * dx + dy * dy;
                    if (!(distSq < minDistSq)) continue;
                    minDistSq = distSq;
                    nearestIndex = i;
                }
                double randomShellDist = random.nextDouble() * maxShellRadius;
                if (!(minDistSq <= randomShellDist * randomShellDist)) continue;
                List list = centerPixels.computeIfAbsent(nearestIndex, k -> new LinkedList());
                list.add(new Pixel(x, y, Math.sqrt(minDistSq)));
            }
        }
        for (Map.Entry entry : centerPixels.entrySet()) {
            ArrayList<Pixel> pixels = new ArrayList<Pixel>((Collection)entry.getValue());
            pixels.sort(Comparator.comparingDouble(p -> p.dist));
            ShellCluster cluster = new ShellCluster();
            clusters.add(cluster);
            Iterator iterator = pixels.iterator();
            if (!iterator.hasNext()) continue;
            Pixel p2 = (Pixel)iterator.next();
            cluster.point = new Point(p2.x, p2.y);
        }
        return (ShellCluster)clusters.get(0);
    }
}

