/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein.noise;

import com.denfop.world.vein.noise.Center;
import com.denfop.world.vein.noise.Pixel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;

public class EDTVoronoi {
    private static void edt1d(double[] f, int n, double[] d, int[] idx) {
        int[] v = new int[n];
        double[] z = new double[n + 1];
        int k = 0;
        v[0] = 0;
        z[0] = Double.NEGATIVE_INFINITY;
        z[1] = Double.POSITIVE_INFINITY;
        int q = 1;
        while (q < n) {
            int vk;
            double s;
            while (!((s = (f[q] + (double)q * (double)q - (f[vk = v[k]] + (double)vk * (double)vk)) / (2.0 * (double)(q - vk))) > z[k])) {
                if (--k >= 0) continue;
                k = 0;
                break;
            }
            v[++k] = q++;
            z[k] = s;
            z[k + 1] = Double.POSITIVE_INFINITY;
        }
        k = 0;
        for (q = 0; q < n; ++q) {
            while (z[k + 1] < (double)q) {
                ++k;
            }
            int p = v[k];
            d[q] = (double)(q - p) * (double)(q - p) + f[p];
            idx[q] = p;
        }
    }

    public static Result computeEDTWithLabels(List<Center> centers, int width, int height) {
        double INF = 1.0E30;
        int[][] seedIndexByCoord = new int[height][width];
        for (int y = 0; y < height; ++y) {
            Arrays.fill(seedIndexByCoord[y], -1);
        }
        for (int i = 0; i < centers.size(); ++i) {
            int xi = (int)Math.round(centers.get((int)i).x);
            int yi = (int)Math.round(centers.get((int)i).y);
            if (xi < 0 || xi >= width || yi < 0 || yi >= height) continue;
            seedIndexByCoord[yi][xi] = i;
        }
        double[][] vertDist = new double[height][width];
        int[][] vertIdxY = new int[height][width];
        double[] f = new double[height];
        double[] d = new double[height];
        int[] iy = new int[height];
        for (int x = 0; x < width; ++x) {
            int y;
            for (y = 0; y < height; ++y) {
                f[y] = seedIndexByCoord[y][x] >= 0 ? 0.0 : 1.0E30;
            }
            EDTVoronoi.edt1d(f, height, d, iy);
            for (y = 0; y < height; ++y) {
                vertDist[y][x] = d[y];
                vertIdxY[y][x] = iy[y];
            }
        }
        double[][] distSq = new double[height][width];
        int[][] nearestIdx = new int[height][width];
        double[] fx = new double[width];
        double[] dx = new double[width];
        int[] ix = new int[width];
        for (int y = 0; y < height; ++y) {
            int x;
            for (x = 0; x < width; ++x) {
                fx[x] = vertDist[y][x];
            }
            EDTVoronoi.edt1d(fx, width, dx, ix);
            for (x = 0; x < width; ++x) {
                int sx = ix[x];
                int sy = vertIdxY[y][sx];
                distSq[y][x] = dx[x];
                int centerIdx = -1;
                if (sx >= 0 && sx < width && sy >= 0 && sy < height) {
                    centerIdx = seedIndexByCoord[sy][sx];
                }
                nearestIdx[y][x] = centerIdx;
            }
        }
        return new Result(distSq, nearestIdx);
    }

    public static Map<Integer, List<Pixel>> collectCenterPixels(Result edt, int width, int height, RandomSource random, double maxShellRadius) {
        HashMap<Integer, List<Pixel>> centerPixels = new HashMap<Integer, List<Pixel>>();
        double[][] distSq = edt.distSq;
        int[][] nearest = edt.nearestIndex;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double shell;
                double thrSq;
                double minDistSq;
                int idx = nearest[y][x];
                if (idx < 0 || !((minDistSq = distSq[y][x]) <= (thrSq = (shell = random.nextDouble() * maxShellRadius) * shell))) continue;
                centerPixels.computeIfAbsent(idx, k -> new LinkedList()).add(new Pixel(x, y, Math.sqrt(minDistSq)));
            }
        }
        return centerPixels;
    }

    public static Map<Integer, List<Pixel>> fastAssign(List<Center> centers, int width, int height, double maxShellRadius, RandomSource rnd) {
        Result edt = EDTVoronoi.computeEDTWithLabels(centers, width, height);
        return EDTVoronoi.collectCenterPixels(edt, width, height, rnd, maxShellRadius);
    }

    public static class Result {
        public final double[][] distSq;
        public final int[][] nearestIndex;

        public Result(double[][] distSq, int[][] nearestIndex) {
            this.distSq = distSq;
            this.nearestIndex = nearestIndex;
        }
    }
}

