/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.config.ModConfig;
import com.denfop.datagen.loader.CustomOreConfig;
import com.denfop.datagen.loader.OreConfigLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GlobalOreFeature
extends Feature<NoneFeatureConfiguration> {
    public GlobalOreFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        if (!((Boolean)ModConfig.COMMON.defaultSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        BlockPos origin = ctx.origin();
        for (CustomOreConfig config : OreConfigLoader.ORES.values()) {
            int veins = Mth.nextInt((RandomSource)random, (int)config.minVeins(), (int)config.maxVeins());
            for (int i = 0; i < veins; ++i) {
                if (random.nextDouble() > config.chance()) continue;
                int x = origin.getX() + random.nextInt(16);
                int y = Mth.nextInt((RandomSource)random, (int)config.minHeight(), (int)config.maxHeight());
                int z = origin.getZ() + random.nextInt(16);
                BlockPos pos = new BlockPos(x, y, z);
                int veinSize = Mth.nextInt((RandomSource)random, (int)config.minVeinSize(), (int)config.maxVeinSize());
                for (int j = 0; j < veinSize; ++j) {
                    BlockPos target = pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
                    if (!level.getBlockState(target).is(config.replaceBlock())) continue;
                    level.getChunk(target).setBlockState(target, config.oreBlock().defaultBlockState(), false);
                }
            }
        }
        return true;
    }
}

