/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.api.IKeyboard;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

public class KeyboardIU
implements IKeyboard {
    private final Map<Player, Set<Key>> playerKeys = new WeakHashMap<Player, Set<Key>>();

    public static boolean keyDown(KeyMapping keyMapping) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyMapping.getKey().getValue());
    }

    public static boolean isKeyDown(int keyMapping) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyMapping);
    }

    @Override
    public boolean isJumpKeyDown(Player player) {
        return this.get(player, Key.JUMP);
    }

    public boolean isAltKeyDown(Player player) {
        return this.get(player, Key.ALT);
    }

    @Override
    public boolean isArmorKey(Player player) {
        return this.get(player, Key.ARMOR);
    }

    @Override
    public boolean isSneakKeyDown(Player player) {
        return player.isShiftKeyDown();
    }

    @Override
    public boolean isForwardKeyDown(Player player) {
        return this.get(player, Key.FORWARD);
    }

    @Override
    public boolean isChangeKeyDown(Player player) {
        return this.get(player, Key.CHANGE);
    }

    @Override
    public boolean isVerticalMode(Player player) {
        return this.get(player, Key.VERTICALMODE);
    }

    @Override
    public boolean isBootsMode(Player player) {
        return this.get(player, Key.BOOTS);
    }

    @Override
    public boolean isLeggingsMode(Player player) {
        return this.get(player, Key.LEGGINGS);
    }

    @Override
    public boolean isFlyModeKeyDown(Player player) {
        return this.get(player, Key.FLYMODE);
    }

    @Override
    public boolean isBlackListModeKeyDown(Player player) {
        return this.get(player, Key.BLACKMODE);
    }

    @Override
    public boolean isBlackListModeViewKeyDown(Player player) {
        return this.get(player, Key.BLACKLISTVIEWMODE);
    }

    public boolean isSaveModeKeyDown(Player player) {
        return this.get(player, Key.SAVEMODE);
    }

    public void sendKeyUpdate(Level level) {
    }

    public void processKeyUpdate(Player player, int keyState) {
        this.playerKeys.put(player, Key.fromInt(keyState));
    }

    public void removePlayerReferences(Player player) {
        this.playerKeys.remove(player);
    }

    private boolean get(Player player, Key key) {
        Set<Key> keys = this.playerKeys.get(player);
        return keys != null && keys.contains((Object)key);
    }

    @Override
    public boolean isStreakKeyDown(Player player) {
        return this.get(player, Key.STREAK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void register(RegisterKeyMappingsEvent event) {
    }

    public static enum Key {
        CHANGE,
        BLACKLISTVIEWMODE,
        FLYMODE,
        VERTICALMODE,
        SAVEMODE,
        SHIFT,
        STREAK,
        BLACKMODE,
        FORWARD,
        JUMP,
        ARMOR,
        BOOTS,
        LEGGINGS,
        ALT;

        public static final Key[] keys;

        public static int toInt(Iterable<Key> keySet) {
            int ret = 0;
            for (Key key : keySet) {
                ret |= 1 << key.ordinal();
            }
            return ret;
        }

        public static Set<Key> fromInt(int keyState) {
            EnumSet<Key> ret = EnumSet.noneOf(Key.class);
            int i = 0;
            while (keyState != 0) {
                if ((keyState & 1) != 0) {
                    ret.add(keys[i]);
                }
                ++i;
                keyState >>= 1;
            }
            return ret;
        }

        static {
            keys = Key.values();
        }
    }
}

