/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ElectricItemManager
implements com.denfop.api.item.energy.ElectricItemManager {
    public static ItemStack getCharged(Item item, double charge) {
        if (!(item instanceof EnergyItem)) {
            throw new IllegalArgumentException("no electric item");
        }
        ItemStack ret = new ItemStack((ItemLike)item).copy();
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    public static void addChargeVariants(Item item, List<ItemStack> list) {
        list.add(ElectricItemManager.getCharged(item, 0.0));
        list.add(ElectricItemManager.getCharged(item, Double.MAX_VALUE));
    }

    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        EnergyItem item = (EnergyItem)stack.getItem();
        assert (item.getMaxEnergy(stack) > 0.0);
        if (this.getCharge(stack) == item.getMaxEnergy(stack)) {
            return 0.0;
        }
        if (!(amount < 0.0) && ModUtils.getSize(stack) <= 1 && item.getTierItem(stack) <= tier) {
            if (!ignoreTransferLimit && amount > item.getTransferEnergy(stack)) {
                amount = item.getTransferEnergy(stack);
            }
            double newCharge = ((Number)stack.getOrDefault(DataComponentsInit.ENERGY, (Object)0)).doubleValue();
            amount = Math.min(amount, item.getMaxEnergy(stack) - newCharge);
            if (!simulate) {
                stack.set(DataComponentsInit.ENERGY, (Object)Math.max(newCharge += amount, 0.0));
            }
            return amount;
        }
        return 0.0;
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        EnergyItem item = (EnergyItem)stack.getItem();
        assert (item.getMaxEnergy(stack) > 0.0);
        if (!(amount < 0.0) && ModUtils.getSize(stack) <= 1 && item.getTierItem(stack) <= tier) {
            if (externally && !item.canProvideEnergy(stack)) {
                return 0.0;
            }
            if (!ignoreTransferLimit && amount > item.getTransferEnergy(stack)) {
                amount = item.getTransferEnergy(stack);
            }
            double newCharge = this.getCharge(stack);
            amount = Math.min(amount, newCharge);
            if (!simulate) {
                stack.set(DataComponentsInit.ENERGY, (Object)Math.max(newCharge -= amount, 0.0));
            }
            return amount;
        }
        return 0.0;
    }

    @Override
    public double getCharge(ItemStack stack) {
        if (!stack.has(DataComponentsInit.ENERGY)) {
            stack.set(DataComponentsInit.ENERGY, (Object)0.0);
        }
        return (Double)stack.get(DataComponentsInit.ENERGY);
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return ((EnergyItem)stack.getItem()).getMaxEnergy(stack);
    }

    @Override
    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.getCharge(stack) >= amount;
    }

    @Override
    public boolean use(ItemStack stack, double amount, LivingEntity entity) {
        double transfer = this.getCharge(stack);
        if (transfer >= amount) {
            ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            return true;
        }
        return false;
    }

    @Override
    public String getToolTip(ItemStack stack) {
        if (stack.getItem() instanceof EnergyItem) {
            double charge = ElectricItem.manager.getCharge(stack);
            return ModUtils.getString(charge) + "/" + ModUtils.getString(((EnergyItem)stack.getItem()).getMaxEnergy(stack)) + " EF";
        }
        return "";
    }

    @Override
    public int getTier(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof EnergyItem ? (int)((EnergyItem)stack.getItem()).getTierItem(stack) : 0;
    }
}

