/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.mechanism.steamturbine.coolant.BlockEntityBaseSteamTurbineCoolant;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuSteamTurbineCoolant;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenSteamTurbineCoolant<T extends ContainerMenuSteamTurbineCoolant>
extends ScreenMain<ContainerMenuSteamTurbineCoolant> {
    boolean hoverPlus = false;
    boolean hoverMinus = false;

    public ScreenSteamTurbineCoolant(ContainerMenuSteamTurbineCoolant guiContainer) {
        super(guiContainer);
        this.addWidget(new TankWidget(this, 69, 8, 37, 58, (IFluidTank)((BlockEntityBaseSteamTurbineCoolant)((ContainerMenuSteamTurbineCoolant)this.container).base).getCoolant()){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((BlockEntityBaseSteamTurbineCoolant)((ContainerMenuSteamTurbineCoolant)ScreenSteamTurbineCoolant.this.container).base).getCoolant().getFluid();
                if (Keyboard.isKeyDown(340)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = ((BlockEntityBaseSteamTurbineCoolant)((ContainerMenuSteamTurbineCoolant)ScreenSteamTurbineCoolant.this.container).base).getCoolant().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 6;
                    fluidY += 6;
                    int fluidWidth = 28;
                    int fluidHeight = 44;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + 97, this.gui.guiTop + 14, 191, 5, 7, 46);
                }
            }
        });
        this.componentList.clear();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (this.hoverPlus) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuSteamTurbineCoolant)this.container).base, 0.0);
        }
        if (this.hoverMinus) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuSteamTurbineCoolant)this.container).base, 1.0);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.hoverMinus = false;
        this.hoverPlus = false;
        if (par1 >= 62 && par2 >= 67 && par1 <= 73 && par2 <= 78) {
            this.hoverPlus = true;
            new TooltipWidget(this, 62, 67, 12, 12).withTooltip("+1").drawForeground(poseStack, par1, par2);
        }
        if (par1 >= 103 && par2 >= 67 && par1 <= 114 && par2 <= 78) {
            this.hoverMinus = true;
            new TooltipWidget(this, 103, 67, 12, 12).withTooltip("-1").drawForeground(poseStack, par1, par2);
        }
        this.draw(poseStack, String.valueOf(((BlockEntityBaseSteamTurbineCoolant)((ContainerMenuSteamTurbineCoolant)this.container).base).getPressure()), 92 - this.getStringWidth(String.valueOf(((BlockEntityBaseSteamTurbineCoolant)((ContainerMenuSteamTurbineCoolant)this.container).base).getPressure())), 69, ModUtils.convertRGBcolorToInt(15, 125, 205));
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        if (this.hoverPlus) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 62, this.guiTop + 67, 244, 13, 12, 12);
        }
        if (this.hoverMinus) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 103, this.guiTop + 67, 244, 0, 12, 12);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisteamturbine_coolant.png");
    }
}

