/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.EmptyWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.mechanism.steam.BlockEntitySteamBoiler;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuSteamBoiler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenSteamBoiler<T extends ContainerMenuSteamBoiler>
extends ScreenMain<ContainerMenuSteamBoiler> {
    public ContainerMenuSteamBoiler container;
    public String name;

    public ScreenSteamBoiler(ContainerMenuSteamBoiler guiContainer) {
        super(guiContainer, EnumTypeStyle.STEAM);
        this.container = guiContainer;
        this.name = Localization.translate(((BlockEntitySteamBoiler)guiContainer.base).getName());
        this.componentList.add(new ScreenWidget(this, 72, 41, EnumTypeComponent.STEAM_PROCESS, new WidgetDefault<EmptyWidget>(new EmptyWidget())));
        this.addWidget(TankWidget.createNormal(this, 46, 22, (IFluidTank)((BlockEntitySteamBoiler)this.container.base).fluidTank));
        this.addWidget(TankWidget.createNormal(this, 96, 22, (IFluidTank)((BlockEntitySteamBoiler)this.container.base).fluidTank1));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("steam_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 11; ++i) {
                compatibleUpgrades.add(Localization.translate("steam_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.draw(poseStack, this.name, (this.imageWidth - this.getStringWidth(this.name)) / 2, 6, 0x404040);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenSteamBoiler.bindTexture(this.getTexture());
        ScreenSteamBoiler.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisteam_machine.png");
    }
}

