/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.SteamInterfaceWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.steam.BlockEntitySteamBioGenerator;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.PressureComponent;
import com.denfop.containermenu.ContainerMenuBioGenerator;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenSteamBioGenerator<T extends ContainerMenuBioGenerator>
extends ScreenMain<ContainerMenuBioGenerator> {
    public final ContainerMenuBioGenerator container;

    public ScreenSteamBioGenerator(ContainerMenuBioGenerator container1) {
        super(container1, EnumTypeStyle.STEAM);
        this.container = container1;
        this.addWidget(new SteamInterfaceWidget(this, 0, 0, this.imageWidth, this.imageHeight));
        this.addWidget(TankWidget.createNormal(this, 100, 21, (IFluidTank)((BlockEntitySteamBioGenerator)this.container.base).fluidTank1));
        this.addComponent(new ScreenWidget(this, 7, 64, EnumTypeComponent.STEAM_FLUID, new WidgetDefault<ComponentSteamEnergy>(((BlockEntitySteamBioGenerator)this.container.base).steam)));
        this.addComponent(new ScreenWidget(this, 10, 54, EnumTypeComponent.NULL, new WidgetDefault<PressureComponent>(((BlockEntitySteamBioGenerator)this.container.base).pressure)));
        this.addComponent(new ScreenWidget(this, 70, 40, EnumTypeComponent.STEAM_PROCESS2, new WidgetDefault<1>(new ComponentProgress((BlockEntityInventory)this.container.base, 1, 0){

            @Override
            public double getBar() {
                return ((BlockEntitySteamBioGenerator)ScreenSteamBioGenerator.this.container.base).getProgress();
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("steam_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 11; ++i) {
                compatibleUpgrades.add(Localization.translate("steam_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        ScreenSteamBioGenerator.bindTexture(this.getTexture());
        int progress = (int)(32.0 * ((BlockEntitySteamBioGenerator)this.container.base).getProgress());
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 88, yoffset + 40, 177, 41, progress, 19);
        }
        String name = Localization.translate(((BlockEntitySteamBioGenerator)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2 + 15, 5, name, 0x404040, false);
        ScreenSteamBioGenerator.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisteam_machine.png");
    }
}

