/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.blockentity.base.BlockEntityMatterGenerator;
import com.denfop.containermenu.ContainerMenuSolidMatter;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenSolidMatter<T extends ContainerMenuSolidMatter>
extends ScreenIndustrialUpgrade<ContainerMenuSolidMatter> {
    public final ContainerMenuSolidMatter container;

    public ScreenSolidMatter(ContainerMenuSolidMatter container1) {
        super(container1);
        this.container = container1;
        final String progress1 = Localization.translate("gui.MolecularTransformer.progress") + ": ";
        this.addWidget(new AdvancedTooltipWidget(this, 58, 54, 117, 67){

            @Override
            protected List<String> getToolTip() {
                return Arrays.asList(progress1 + ModUtils.getString(((BlockEntityMatterGenerator)ScreenSolidMatter.this.container.base).getProgress() * 100.0) + "%");
            }
        });
    }

    @Override
    protected void renderBg(GuiGraphics poseStack, float f, int x, int y) {
        super.renderBg(poseStack, f, x, y);
        ScreenSolidMatter.bindTexture(this.getTexture());
        int progress = (int)(54.0 * (double)((BlockEntityMatterGenerator)this.container.base).getChargeLevel());
        int xoffset = (this.width - this.imageWidth) / 2;
        int yoffset = (this.height - this.imageHeight) / 2;
        int index = 0;
        switch (((BlockEntityMatterGenerator)this.container.base).getTeBlock().getId()) {
            case 4: {
                index = 0;
                break;
            }
            case 1: {
                index = 1;
                break;
            }
            case 0: {
                index = 2;
                break;
            }
            case 7: {
                index = 3;
                break;
            }
            case 5: {
                index = 4;
                break;
            }
            case 6: {
                index = 5;
                break;
            }
            case 2: {
                index = 6;
                break;
            }
            case 3: {
                index = 7;
            }
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 62, yoffset + 58, 181, 5 + 15 * index, progress, 6);
        }
    }

    public String getName() {
        return ((BlockEntityMatterGenerator)this.container.base).getInventoryName();
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/GuiSolidMatter.png".toLowerCase());
    }
}

