/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.TankWidget;
import com.denfop.blockentity.mechanism.solardestiller.BlockEntityBaseSolarDestiller;
import com.denfop.containermenu.ContainerMenuSolarDestiller;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class ScreenSolarDestiller<T extends ContainerMenuSolarDestiller>
extends ScreenMain<ContainerMenuSolarDestiller> {
    public ScreenSolarDestiller(ContainerMenuSolarDestiller container) {
        super(container, ((BlockEntityBaseSolarDestiller)container.base).getStyle());
        this.imageHeight = 170;
        this.inventory.setY(101);
        this.componentList.clear();
        this.addWidget(new TankWidget(this, 38, 20, 22, 40, (IFluidTank)((BlockEntityBaseSolarDestiller)container.base).inputTank){

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = this.tank.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 3;
                    fluidY += 3;
                    int fluidWidth = 17;
                    int fluidHeight = 45;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, ScreenSolarDestiller.this.guiLeft + fluidX, (double)ScreenSolarDestiller.this.guiTop + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + this.x + 2, this.gui.guiTop + this.y + 2, 179, 53, 19, 46);
                }
            }
        });
        this.addWidget(new TankWidget(this, 115, 20, 22, 40, (IFluidTank)((BlockEntityBaseSolarDestiller)container.base).outputTank){

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = this.tank.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 3;
                    fluidY += 3;
                    int fluidWidth = 17;
                    int fluidHeight = 45;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 2.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    2.bindBlockTexture();
                    this.gui.drawSprite(poseStack, ScreenSolarDestiller.this.guiLeft + fluidX, (double)ScreenSolarDestiller.this.guiTop + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + this.x + 2, this.gui.guiTop + this.y + 2, 179, 53, 19, 46);
                }
            }
        });
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        String name = Localization.translate(((BlockEntityBaseSolarDestiller)((ContainerMenuSolarDestiller)this.container).base).getName());
        if (!this.isBlack) {
            this.drawXCenteredString(poseStack, this.imageWidth / 2, 6, Component.nullToEmpty((String)name), ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        } else {
            this.drawXCenteredString(poseStack, this.imageHeight / 2, 6, Component.nullToEmpty((String)name), ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        this.bindTexture();
        if (((BlockEntityBaseSolarDestiller)((ContainerMenuSolarDestiller)this.container).base).canWork()) {
            int tick = ((BlockEntityBaseSolarDestiller)((ContainerMenuSolarDestiller)this.container).base).getTickRate();
            double progress = (double)(((BlockEntityBaseSolarDestiller)((ContainerMenuSolarDestiller)this.container).base).getWorld().getGameTime() % (long)tick) / ((double)tick * 1.0);
            progress = Math.min(1.0, progress);
            this.drawTexturedModalRect(poseStack, this.guiLeft + 62, this.guiTop + 40, 201, 1, (int)(52.0 * progress), 10);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        switch (((BlockEntityBaseSolarDestiller)((ContainerMenuSolarDestiller)this.container).base).getStyle()) {
            case DEFAULT: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisolardestiller.png");
            }
            case ADVANCED: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiadvsolardestiller.png");
            }
            case IMPROVED: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiimpsolardestiller.png");
            }
            case PERFECT: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guipersolardestiller.png");
            }
            case PHOTONIC: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiphosolardestiller.png");
            }
        }
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisolardestiller.png");
    }
}

