/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.pollution.radiation.EnumCoefficient;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.mechanism.BlockEntitySoilAnalyzer;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuSoilAnalyzer;
import com.denfop.potion.IUPotion;
import com.denfop.recipes.BaseRecipes;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public class ScreenSoilAnalyzer<T extends ContainerMenuSoilAnalyzer>
extends ScreenMain<ContainerMenuSoilAnalyzer> {
    public ScreenSoilAnalyzer(ContainerMenuSoilAnalyzer guiContainer) {
        super(guiContainer);
        this.imageHeight = 123;
        this.componentList.clear();
        this.addComponent(new ScreenWidget(this, 21, 88, EnumTypeComponent.ENERGY, new WidgetDefault<Energy>(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).energy)));
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        if (!((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).analyzed) {
            new AdvancedTooltipWidget(this, 28, 24, 147, 73).withTooltip(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).progress.getBar() * 100.0) + " %").drawForeground(poseStack, par1, par2);
        } else {
            Radiation radiation = ((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation;
            if (radiation == null) {
                new AdvancedTooltipWidget(this, 28, 24, 147, 73).withTooltip(Localization.translate("radiation.info_not")).drawForeground(poseStack, par1, par2);
            } else {
                new AdvancedTooltipWidget(this, 28, 24, 147, 73).withTooltip(Localization.translate("radiation." + radiation.getLevel().name().toLowerCase()) + (String)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getLevel().ordinal() > 1 ? "\n" + Localization.translate("radiation.info1") + "\n" + Localization.translate(((MobEffect)MobEffects.HUNGER.value()).getDescriptionId()) + "\n" + Localization.translate(((MobEffect)MobEffects.BLINDNESS.value()).getDescriptionId()) + "\n" + Localization.translate(((MobEffect)MobEffects.MOVEMENT_SLOWDOWN.value()).getDescriptionId()) + "\n" + Localization.translate(((MobEffect)MobEffects.POISON.value()).getDescriptionId()) : "") + (String)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getLevel().ordinal() == 3 ? "\n" + Localization.translate("radiation.info2") + "\n" + Localization.translate(IUPotion.radiation.getDescriptionId()) : "") + (String)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getLevel().ordinal() == 4 ? "\n" + Localization.translate("radiation.info2") + "\n" + Localization.translate(IUPotion.radiation.getDescriptionId()) + "\n" + Localization.translate(((MobEffect)MobEffects.WITHER.value()).getDescriptionId()) : "") + (String)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getLevel().ordinal() == 2 ? "\n" + Localization.translate("radiation.info3") : "") + (String)(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getLevel().ordinal() > 2 ? "\n" + Localization.translate("radiation.info5") : "") + "\n" + Localization.translate("radiation.info4") + "\n" + BaseRecipes.getBlockStack(BlockBaseMachine3Entity.radiation_purifier).getDisplayName().getString()).drawForeground(poseStack, par1, par2);
            }
        }
        if (((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).analyzed) {
            if (((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation != null) {
                new AdvancedTooltipWidget(this, 39, 91, 76, 103).withTooltip(Localization.translate("radiation.dose") + Math.max(1, (int)((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getRadiation()) + " " + ModUtils.getUnit(((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation.getCoef()) + "Sv").drawForeground(poseStack, par1, par2);
            } else {
                new AdvancedTooltipWidget(this, 39, 91, 76, 103).withTooltip(Localization.translate("radiation.dose") + Math.max(0.5, 0.0) + " " + ModUtils.getUnit(EnumCoefficient.NANO) + "Sv").drawForeground(poseStack, par1, par2);
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.bindTexture();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation == null) {
            this.drawTexturedRect(poseStack, 38.0, 91.0, 5.0, 13.0, 181.0, 17.0);
        } else {
            Radiation radiation = ((BlockEntitySoilAnalyzer)((ContainerMenuSoilAnalyzer)this.container).base).radiation;
            if (radiation.getLevel() == EnumLevelRadiation.LOW) {
                double translate = 4.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 38.0 + translate, 91.0, 5.0, 13.0, 181.0, 17.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.DEFAULT) {
                double translate = 8.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 44.0 + translate, 91.0, 5.0, 13.0, 181.0, 17.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.MEDIUM) {
                double translate = 8.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 52.0 + translate, 91.0, 5.0, 13.0, 181.0, 17.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.HIGH) {
                double translate = 8.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 60.0 + translate, 91.0, 5.0, 13.0, 181.0, 17.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.VERY_HIGH) {
                double translate = 8.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 68.0 + translate, 91.0, 5.0, 13.0, 181.0, 17.0);
            }
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisoilanalyzer.png");
    }
}

