/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.mechanism.BlockEntityResearchTableSpace;
import com.denfop.containermenu.ContainerMenuResearchTableSpace;
import com.denfop.screen.ScreenDefaultResearchTable;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenResearchTableSpace;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class ScreenResourceBody
extends ScreenDefaultResearchTable {
    boolean hoverDelete;

    public ScreenResourceBody(ScreenResearchTableSpace tileEntityResearchTableSpace) {
        super(tileEntityResearchTableSpace, 25, 25, 150, 150);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        IBody planet = this.getTile().focusedPlanet;
        Data data = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).base).dataMap.get(planet);
        for (int i = 0; i < planet.getResources().size(); ++i) {
            IBaseResource resource = planet.getResources().get(i);
            if (resource.getItemStack() != null) {
                new TooltipWidget(this.getTile(), this.x + this.offsetX1 + (15 + i % 7 * 18), this.y + this.offsetY1 + (27 + 18 * (i / 7)), 18, 18).withTooltip((!((double)resource.getPercentPanel() > data.getPercent()) ? resource.getItemStack().getDisplayName().getString() : "???") + "\n" + Localization.translate("iu.space_chance") + " " + ModUtils.getString((double)resource.getChance() * 100.0 / (double)resource.getMaxChance()) + "%\n" + Localization.translate("iu.space_rover") + " " + Localization.translate("iu.space_rover_" + resource.getTypeRovers().name().toLowerCase())).drawForeground(poseStack, par1, par2);
            }
            if (resource.getFluidStack() == null || (double)resource.getPercentPanel() > data.getPercent()) continue;
            new TooltipWidget(this.getTile(), this.x + this.offsetX1 + (15 + i % 7 * 18), this.y + this.offsetY1 + (27 + 18 * (i / 7)), 16, 16).withTooltip((!((double)resource.getPercentPanel() > data.getPercent()) ? resource.getFluidStack().getHoverName().getString() : "???") + "\n" + (!((double)resource.getPercentPanel() > data.getPercent()) ? Localization.translate("iu.space_amount") : "??? mb") + " " + resource.getFluidStack().getAmount() + "mb\n" + Localization.translate("iu.space_chance") + " " + ModUtils.getString((double)resource.getChance() * 100.0 / (double)resource.getMaxChance()) + "%\n" + Localization.translate("iu.space_rover") + " " + Localization.translate("iu.space_rover_" + resource.getTypeRovers().name().toLowerCase())).drawForeground(poseStack, par1, par2);
        }
        this.hoverDelete = false;
        if (par1 >= this.x + this.offsetX1 + this.width - 20 && par2 <= this.x + this.offsetX1 + this.width - 20 + 15 && par2 >= this.y + this.offsetY1 + 5 && par2 <= this.y + this.offsetY1 + 20) {
            this.hoverDelete = true;
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.getTile().drawString(poseStack, Localization.translate("iu.space.planet.resource"), this.getTile().guiLeft + this.x + this.offsetX1 + this.width / 2 - this.tile.getStringWidth(Localization.translate("iu.space.planet.resource")) / 2, this.getTile().guiTop + this.y + this.offsetY1 + 5, ModUtils.convertRGBAcolorToInt(255, 255, 255));
        IBody planet = this.getTile().focusedPlanet;
        PoseStack pose = poseStack.pose();
        int guiLeft = this.getTile().guiLeft + this.x + this.offsetX1;
        int guiTop = this.getTile().guiTop + this.y + this.offsetY1;
        pose.pushPose();
        pose.translate((float)(guiLeft + this.width - 20), (float)(guiTop + 5), 20.0f);
        ScreenIndustrialUpgrade.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"));
        pose.scale(0.5f, 0.5f, 1.0f);
        if (!this.hoverDelete) {
            this.getTile().drawTexturedModalRect(poseStack, 0, 0, 139, 32, 30, 30);
        } else {
            this.getTile().drawTexturedModalRect(poseStack, 0, 0, 170, 32, 30, 30);
        }
        pose.popPose();
        Data data = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).base).dataMap.get(planet);
        for (int i = 0; i < planet.getResources().size(); ++i) {
            IBaseResource baseResource = planet.getResources().get(i);
            if ((double)baseResource.getPercentPanel() > data.getPercent()) {
                // empty if block
            }
            if (baseResource.getItemStack() == null && baseResource.getFluidStack() == null) continue;
            if ((double)baseResource.getPercentPanel() <= data.getPercent() && baseResource.getItemStack() != null) {
                RenderSystem.enableBlend();
                pose.translate(0.0f, 0.0f, -100.0f);
                poseStack.renderItem(baseResource.getItemStack(), 15 + i % 7 * 18 + guiLeft, 27 + 18 * (i / 7) + guiTop);
                poseStack.renderItemDecorations(Minecraft.getInstance().font, baseResource.getItemStack(), 15 + i % 7 * 18 + guiLeft, 27 + 18 * (i / 7) + guiTop);
                pose.translate(0.0f, 0.0f, 100.0f);
                RenderSystem.disableBlend();
                continue;
            }
            if ((double)baseResource.getPercentPanel() <= data.getPercent() && baseResource.getFluidStack() != null) {
                int fluidX = 15 + i % 7 * 18 + 1;
                int fluidY = 27 + 18 * (i / 7) + 1;
                int fluidWidth = 16;
                int fluidHeight = 16;
                Fluid fluid = baseResource.getFluidStack().getFluid();
                IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                TextureAtlasSprite sprite = ScreenWidget.getBlockTextureMap().getSprite(extensions.getStillTexture(baseResource.getFluidStack()));
                int color = extensions.getTintColor();
                ScreenWidget.bindBlockTexture();
                this.getTile().drawSprite(poseStack, guiLeft + fluidX, guiTop + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
                continue;
            }
            ItemStack stack = new ItemStack((ItemLike)Items.BARRIER);
            RenderSystem.enableBlend();
            poseStack.renderItem(stack, 15 + i % 7 * 18 + guiLeft, 27 + 18 * (i / 7) + guiTop);
            poseStack.renderItemDecorations(Minecraft.getInstance().font, stack, 15 + i % 7 * 18 + guiLeft, 27 + 18 * (i / 7) + guiTop);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, ScrollDirection direction) {
        return super.mouseScrolled(mouseX, mouseY, direction);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY) {
        if (this.hoverDelete) {
            this.getTile().defaultResearchGuis.remove(this);
            ((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).player.playSound(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY);
    }
}

