/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.items.relocator.ItemStackRelocator;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.network.packet.PacketRelocatorTeleportPlayer;
import com.denfop.network.packet.PacketRemoveRelocatorPoint;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ScreenRelocator<T extends ContainerMenuBase<ItemStackRelocator>>
extends ScreenMain<ContainerMenuBase<ItemStackRelocator>> {
    private int value;

    public ScreenRelocator(ContainerMenuBase<ItemStackRelocator> guiContainer) {
        super(guiContainer);
        this.imageWidth = 176;
        this.imageHeight = 98;
        this.componentList.clear();
        if (((ItemStackRelocator)guiContainer.base).player.level().isClientSide) {
            ((ItemStackRelocator)this.container.base).points = new ArrayList<Point>(RelocatorNetwork.instance.getPoints(((ItemStackRelocator)guiContainer.base).player));
            this.value = 0;
        }
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d4, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (mouseX >= 7 && mouseY >= 18 && mouseX <= 168 && mouseY <= 78) {
            if (scrollDirection == ScrollDirection.up) {
                --this.value;
                this.value = Math.max(this.value, 0);
            } else if (scrollDirection == ScrollDirection.down) {
                ++this.value;
                this.value = Math.min(this.value, ((ItemStackRelocator)this.container.base).points.size() / 4);
            }
        }
        return super.mouseScrolled(d, d2, d4, d3);
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points;
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        for (int index = 4 * this.value; index < Math.min(4 + 4 * this.value, pointList.size()); ++index) {
            int x1 = 10;
            int y1 = 20 + 15 * (index % 4);
            int x2 = 153;
            int y2 = 20 + 15 * (index % 4);
            if (x >= x2 && x <= x2 + 12 && y >= y2 && y <= y2 + 11) {
                new PacketRelocatorTeleportPlayer((Player)this.minecraft.player, pointList.get(index));
                ItemStack stack = ((ItemStackRelocator)this.container.base).itemStack1;
                if (ElectricItem.manager.canUse(stack, 1000000.0)) {
                    this.minecraft.player.closeContainer();
                }
            }
            if (x < x1 || x > x1 + 12 || y < y1 || y > y1 + 11) continue;
            new PacketRemoveRelocatorPoint((Player)this.minecraft.player, pointList.get(index));
            this.minecraft.player.closeContainer();
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points = new ArrayList<Point>(RelocatorNetwork.instance.getPoints(((ItemStackRelocator)this.container.base).player));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 4 * this.value; i < Math.min(4 + 4 * this.value, pointList.size()); ++i) {
            String originalName = pointList.get(i).getName();
            String truncatedName = originalName.length() > 10 ? originalName.substring(0, 10) : originalName;
            Point point = pointList.get(i);
            this.draw(poseStack, truncatedName, 24, 22 + 15 * (i % 4), ModUtils.convertRGBcolorToInt(255, 255, 255));
            new TooltipWidget(this, 7, 22 + 20 * (i % 4), 160, 14).withTooltip(point.getPos().toString().substring(8)).drawForeground(poseStack, par1, par2);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.bindTexture();
        poseStack.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = Localization.translate(((ItemStackRelocator)this.container.base).itemStack1.getDescriptionId());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 8) / scale);
        poseStack.drawString(Minecraft.getInstance().font, name, textX, textY, ModUtils.convertRGBcolorToInt(255, 255, 255), false);
        pose.scale(1.0f / scale, 1.0f / scale, 1.0f);
        pose.popPose();
        this.bindTexture();
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points;
        for (int i = 4 * this.value; i < Math.min(4 + 4 * this.value, pointList.size()); ++i) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 8, this.guiTop + 19 + 15 * (i % 4), 8, 171, 160, 14);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guirelocator.png");
    }
}

