/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.IUItem;
import com.denfop.api.recipe.InventoryMultiRecipes;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ImageInterfaceWidget;
import com.denfop.api.widget.ItemStackWidget;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.mechanism.EnumTypeMachines;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcessRender;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.containermenu.SlotInvSlot;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ScreenMultiMachine<T extends ContainerMenuMultiMachine>
extends ScreenMain<ContainerMenuMultiMachine> {
    private final ContainerMenuMultiMachine container;
    private final ScreenWidget process;
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ScreenMultiMachine(ContainerMenuMultiMachine container1) {
        super(container1, ((BlockEntityMultiMachine)container1.base).getMachine().getComponent());
        this.container = container1;
        if (((BlockEntityMultiMachine)container1.base).getMachine().sizeWorkingSlot == 8) {
            this.imageWidth += 60;
            this.addWidget(new ImageInterfaceWidget(this, 0, 0, this.imageWidth, this.imageHeight));
        } else {
            this.imageWidth = 192;
        }
        this.process = new ScreenWidget(this, 0, 0, EnumTypeComponent.MULTI_PROCESS, new WidgetDefault<ComponentProcessRender>(new ComponentProcessRender(((BlockEntityMultiMachine)container1.base).multi_process, ((BlockEntityMultiMachine)container1.base).getTypeMachine())));
        this.addComponent(new ScreenWidget(this, 4, 15, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.addComponent(new ScreenWidget(this, 10, 45, EnumTypeComponent.ENERGY, new WidgetDefault<Energy>(((BlockEntityMultiMachine)this.container.base).energy)));
        if (((BlockEntityMultiMachine)this.container.base).getMachine().type != EnumTypeMachines.Centrifuge && ((BlockEntityMultiMachine)this.container.base).sizeWorkingSlot != 8) {
            this.addComponent(new ScreenWidget(this, 27, 47, EnumTypeComponent.COLD, new WidgetDefault<CoolComponent>(((BlockEntityMultiMachine)this.container.base).cold)));
        }
        if (((BlockEntityMultiMachine)this.container.base).tank != null) {
            this.addComponent(new ScreenWidget(this, 27, 63, EnumTypeComponent.WATER, new WidgetDefault<FluidTank>(((BlockEntityMultiMachine)this.container.base).tank)));
        }
        if (((BlockEntityMultiMachine)this.container.base).getMachine().type == EnumTypeMachines.Centrifuge) {
            this.addComponent(new ScreenWidget(this, 27, 63, EnumTypeComponent.COLD, new WidgetDefault<HeatComponent>(((BlockEntityMultiMachine)this.container.base).heat)));
        }
        this.addComponent(new ScreenWidget(this, 27, 63, EnumTypeComponent.EXP, new WidgetDefault<ComponentBaseEnergy>(((BlockEntityMultiMachine)this.container.base).exp)));
        this.isBlack = false;
        if (((BlockEntityMultiMachine)this.container.base).multi_process.quickly) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
        }
        if (((BlockEntityMultiMachine)this.container.base).multi_process.modulesize) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
        }
        if (((BlockEntityMultiMachine)this.container.base).multi_process.modulestorage) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
        }
        if (((BlockEntityMultiMachine)this.container.base).multi_process.module_infinity_water) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
        }
        if (((BlockEntityMultiMachine)this.container.base).multi_process.module_separate) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
        }
        if (((BlockEntityMultiMachine)this.container.base).solartype != null) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module6.getStack(((BlockEntityMultiMachine)this.container.base).solartype.meta), 1));
        }
        if (((BlockEntityMultiMachine)this.container.base).cold.upgrade && ((BlockEntityMultiMachine)this.container.base).getTypeMachine() != EnumTypeMachines.Centrifuge) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.coolupgrade.getStack(((BlockEntityMultiMachine)this.container.base).cold.meta), 1));
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.drawForeground(poseStack, mouseX, mouseY);
        if (((BlockEntityMultiMachine)this.container.base).getMachine().type == EnumTypeMachines.FARMER) {
            this.draw(poseStack, String.valueOf(((BlockEntityMultiMachine)this.container.base).getFertilizer()), 12, 35, ModUtils.convertRGBcolorToInt(0, 0, 0));
            new TooltipWidget(this, 10, 33, 10, 10).withTooltip(Localization.translate("iu.farmer.fertilizer.info") + "\n" + Localization.translate("iu.farmer.fertilizer.info1")).drawForeground(poseStack, mouseX, mouseY);
        }
        int i = 0;
        for (Slot slot : this.container.slots) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.x;
            int yY = slot.y;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.inventory instanceof InventoryMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.setX(xX);
            this.process.setY(yY + 19);
            this.process.drawForeground(poseStack, mouseX, mouseY);
            ++i;
        }
        i = 0;
        for (ItemStack stack : this.itemStackList) {
            new TooltipWidget(this, this.imageWidth, 5 + i * 18, 16, 16).withTooltip(stack.getDisplayName().getString()).drawForeground(poseStack, mouseX, mouseY);
            ++i;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenMultiMachine.bindTexture(this.getTexture());
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, j, k, 0, 0, 176, this.imageHeight);
        for (ScreenWidget guiElement : this.elements) {
            guiElement.drawBackground(poseStack, this.guiLeft, this.guiTop);
        }
        ScreenMultiMachine.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
        ScreenMultiMachine.bindTexture(this.getTexture());
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        this.drawBackground(poseStack);
        int i = 0;
        for (Slot slot : this.container.slots) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.x;
            int yY = slot.y;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.inventory instanceof InventoryMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.setX(xX);
            this.process.setY(yY + 19);
            this.process.drawBackground(poseStack, xoffset, yoffset);
            ++i;
        }
        ScreenMultiMachine.bindTexture(this.getTexture());
        String name = Localization.translate(((BlockEntityMultiMachine)this.container.base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 6) / scale);
        this.draw(poseStack, name, textX, textY, 0x404040);
        pose.popPose();
        i = 0;
        for (ItemStack stack : this.itemStackList) {
            new ItemStackWidget(this, this.imageWidth, 5 + i * 18, () -> stack).drawBackground(poseStack, this.guiLeft, this.guiTop);
            ++i;
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine_main.png");
    }
}

